package com.atlassian.vcache;

import com.atlassian.annotations.PublicApi;

import java.util.Optional;

/**
 * Builder for creating {@link RequestCacheSettings} instances.
 *
 * @since 1.13.0
 */
@PublicApi
public class RequestCacheSettingsBuilder {

    private Optional<ChangeRate> changeRate = Optional.empty();

    /**
     * Provides a hint on the expected change rate for data updates.
     *
     * @param hint the expected change rate for data updates.
     * @return the builder
     */
    public RequestCacheSettingsBuilder dataChangeRateHint(final ChangeRate hint) {
        this.changeRate = Optional.of(hint);
        return this;
    }

    /**
     * Returns a new {@link RequestCacheSettings} instance configured using the supplied settings.
     *
     * @return a new {@link RequestCacheSettings} instance configured using the supplied settings.
     */
    public RequestCacheSettings build() {
        return new RequestCacheSettings(changeRate.orElse(ChangeRate.HIGH_CHANGE));
    }
}
