package com.atlassian.vcache;

import com.atlassian.annotations.PublicApi;

import javax.annotation.Nullable;
import java.io.Serializable;

/**
 * Represents an identifier for use in compare-and-swap operations. The instance may be serialized if the instance
 * needs to be stored across requests. Use {@link Object#equals(Object)} to compare two instances for equality.
 *
 * @since 1.0
 */
@PublicApi
public interface CasIdentifier extends Serializable {
    @Override
    boolean equals(@Nullable Object other);
}
