package com.atlassian.vcache;

import com.atlassian.annotations.PublicApi;

/**
 * Represents a failure occurred when using the VCache API.
 *
 * @since 1.0
 */
@PublicApi
public class VCacheException extends RuntimeException {
    /**
     * Creates an instance with the supplied message.
     *
     * @param message the message for the exception.
     */
    public VCacheException(String message) {
        super(message);
    }

    /**
     * Creates an instance with the supplied message and cause.
     *
     * @param message the message for the exception.
     * @param cause   the cause of the exception.
     */
    public VCacheException(String message, Throwable cause) {
        super(message, cause);
    }
}

