/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.utils.process;

import com.atlassian.utils.process.Watchdog;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import javax.annotation.Nonnull;

class WatchdogAwareInputStream
extends FilterInputStream {
    private final Watchdog watchdog;

    WatchdogAwareInputStream(InputStream in, Watchdog watchdog) {
        super(in);
        this.watchdog = Objects.requireNonNull(watchdog, "watchdog");
    }

    @Override
    public int read() throws IOException {
        this.watchdog.resetWatchdog();
        return super.read();
    }

    @Override
    public int read(@Nonnull byte[] b) throws IOException {
        this.watchdog.resetWatchdog();
        return super.read(b);
    }

    @Override
    public int read(@Nonnull byte[] b, int off, int len) throws IOException {
        this.watchdog.resetWatchdog();
        return super.read(b, off, len);
    }
}

