/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.utils.process;

import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.LatchedRunnable;
import com.atlassian.utils.process.ProcessException;
import com.atlassian.utils.process.ProcessHandler;
import com.atlassian.utils.process.ProcessMonitor;
import com.atlassian.utils.process.ProcessNotStartedException;
import com.atlassian.utils.process.ProcessTimeoutException;
import com.atlassian.utils.process.ProcessUtils;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.jvnet.winp.WinProcess;

public class ExternalProcessImpl
implements ExternalProcess {
    private static final Logger log = Logger.getLogger(ExternalProcessImpl.class);
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase();
    private boolean asynchronous;
    private final AtomicBoolean canceled;
    private final List<String> command;
    private final ExecutorService executorService;
    private final List<ProcessMonitor> monitors;
    private Map<String, String> environment;
    private boolean escapeInternalDoubleQuotesOnWindows;
    private ProcessException processException;
    private boolean useQuotesInBatArgumentsWorkaround;
    private File workingDir;
    private volatile LatchedRunnable errorPump;
    private volatile long executionTimeout;
    private volatile boolean finished;
    private volatile ProcessHandler handler;
    private volatile long idleTimeout;
    private volatile LatchedRunnable inputPump;
    private volatile boolean inputPumpInterruptedAfterProcessFinished;
    private volatile long lastWatchdogReset;
    private volatile LatchedRunnable outputPump;
    private volatile Process process;
    private volatile long startTime;

    public ExternalProcessImpl(ExecutorService executorService, String[] command, ProcessHandler handler) {
        this(executorService, Arrays.asList(command), handler);
    }

    public ExternalProcessImpl(ExecutorService executorService, List<String> command, ProcessHandler handler) {
        this.command = command;
        this.executorService = executorService;
        this.handler = handler;
        this.canceled = new AtomicBoolean(false);
        this.finished = false;
        this.idleTimeout = TimeUnit.MINUTES.toMillis(1L);
        this.monitors = new CopyOnWriteArrayList<ProcessMonitor>();
        this.startTime = -1L;
    }

    public ExternalProcessImpl(ExecutorService executorService, String commandLine, ProcessHandler handler) {
        this(executorService, ProcessUtils.tokenizeCommand(commandLine), handler);
    }

    public void addMonitor(ProcessMonitor monitor) {
        this.monitors.add(monitor);
    }

    @Override
    public void cancel() {
        if (this.canceled.compareAndSet(false, true)) {
            this.internalCancel(false);
        }
    }

    @Override
    public void execute() {
        this.start();
        this.finish();
    }

    @Override
    public void executeWhile(Runnable runnable) {
        this.start();
        if (runnable != null) {
            runnable.run();
        }
        this.finish();
    }

    @Override
    public void finish() {
        if (this.finished) {
            return;
        }
        try {
            do {
                long checkTime = this.getTimeoutTime();
                this.awaitPump(this.outputPump, checkTime);
                this.awaitPump(this.errorPump, checkTime);
                this.awaitPumpOrProcess(this.inputPump, checkTime);
            } while (!this.isTimedOut() && this.areOutputPumpsRunning() && !Thread.currentThread().isInterrupted());
        }
        finally {
            if (Thread.currentThread().isInterrupted()) {
                this.handleProcessInterrupted();
                Thread.interrupted();
            }
            this.wrapUpProcess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean finish(int maxWait) {
        if (this.finished) {
            return true;
        }
        long endTime = System.currentTimeMillis() + (long)maxWait;
        try {
            do {
                long checkTime = Math.min(endTime, this.getTimeoutTime());
                this.awaitPump(this.outputPump, checkTime);
                this.awaitPump(this.errorPump, checkTime);
                this.awaitPumpOrProcess(this.inputPump, checkTime);
            } while (System.currentTimeMillis() < endTime && !this.isTimedOut() && this.areOutputPumpsRunning() && !Thread.currentThread().isInterrupted());
        }
        finally {
            if (Thread.currentThread().isInterrupted()) {
                this.handleProcessInterrupted();
            }
            if (!this.areOutputPumpsRunning() || this.isTimedOut()) {
                this.wrapUpProcess();
            }
        }
        return this.finished;
    }

    @Override
    public String getCommandLine() {
        StringBuilder builder = new StringBuilder();
        for (String s : this.command) {
            if (builder.length() > 0) {
                builder.append(" ");
            }
            builder.append(s);
        }
        return builder.toString();
    }

    @Override
    public ProcessHandler getHandler() {
        return this.handler;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    public long getTimeoutTime() {
        long timeout = this.lastWatchdogReset + this.idleTimeout;
        if (this.executionTimeout > 0L && this.startTime > 0L) {
            timeout = Math.min(timeout, this.startTime + this.executionTimeout);
        }
        return timeout;
    }

    @Override
    public boolean isAlive() {
        try {
            if (this.process != null) {
                this.process.exitValue();
            }
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
        return false;
    }

    @Override
    public boolean isCanceled() {
        return this.canceled.get();
    }

    @Override
    public boolean isTimedOut() {
        return this.getTimeoutTime() < System.currentTimeMillis();
    }

    public void removeMonitor(ProcessMonitor monitor) {
        this.monitors.remove(monitor);
    }

    @Override
    public void resetWatchdog() {
        this.lastWatchdogReset = System.currentTimeMillis();
    }

    public void setAsynchronous(boolean asynchronous) {
        this.asynchronous = asynchronous;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment = environment;
    }

    public void setEscapeInternalDoubleQuotesOnWindows(boolean escapeInternalDoubleQuotesOnWindows) {
        this.escapeInternalDoubleQuotesOnWindows = escapeInternalDoubleQuotesOnWindows;
    }

    public void setExecutionTimeout(long executionTimeout) {
        this.executionTimeout = executionTimeout;
    }

    protected void setHandler(ProcessHandler handler) {
        this.handler = handler;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    @Deprecated
    public void setSuppressSpecialWindowsBehaviour(boolean suppressSpecialWindowsBehaviour) {
    }

    @Deprecated
    public void setTimeout(long timeout) {
        this.setIdleTimeout(timeout);
    }

    public void setUseQuotesInBatArgumentsWorkaround(boolean useQuotesInBatArgumentsWorkaround) {
        this.useQuotesInBatArgumentsWorkaround = useQuotesInBatArgumentsWorkaround;
    }

    @Deprecated
    public void setUseWindowsEncodingWorkaround(boolean useWindowsEncodingWorkaround) {
    }

    public void setWorkingDir(File workingDir) {
        this.workingDir = workingDir;
    }

    @Override
    public void start() {
        if (this.startTime != -1L) {
            throw new IllegalStateException("An ExternalProcess can only be started once. Create a new instance if you need to rerun a process.");
        }
        try {
            this.startTime = System.currentTimeMillis();
            this.notifyBeforeStart();
            this.process = this.createProcess(this.escapeArguments(this.command), this.environment, this.workingDir);
            this.setupIOPumps();
        }
        catch (IOException e) {
            this.processException = new ProcessNotStartedException(this.command.get(0) + " could not be started", e);
        }
    }

    protected List<String> escapeArguments(List<String> commandArgs) {
        if (this.escapeInternalDoubleQuotesOnWindows && this.isWindows()) {
            for (int i = 0; i < commandArgs.size(); ++i) {
                commandArgs.set(i, this.escapeArgument(commandArgs.get(i)));
            }
        }
        return commandArgs;
    }

    protected boolean isWindows() {
        return OS_NAME.contains("windows");
    }

    private boolean areOutputPumpsRunning() {
        LatchedRunnable output = this.outputPump;
        LatchedRunnable error = this.errorPump;
        return output != null && output.isRunning() || error != null && error.isRunning();
    }

    private Process createDefaultProcess(List<String> command, Map<String, String> environment, File workingDir) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(command).directory(workingDir);
        if (environment != null) {
            builder.environment().putAll(environment);
        }
        if (log.isDebugEnabled()) {
            this.logProcessDetails(builder);
        }
        return builder.start();
    }

    protected Process createProcess(List<String> command, Map<String, String> environment, File workingDir) throws IOException {
        if (this.useQuotesInBatArgumentsWorkaround && this.isWindows() && this.isWindowsShellFile(command)) {
            return this.createWindowsShellProcess(command, environment, workingDir);
        }
        return this.createDefaultProcess(command, environment, workingDir);
    }

    private void awaitPump(LatchedRunnable runnable, long latestTime) {
        if (runnable != null) {
            long timeout = latestTime - System.currentTimeMillis();
            if (timeout < 1L) {
                timeout = 1L;
            }
            runnable.await(timeout);
        }
    }

    private void awaitPumpOrProcess(LatchedRunnable runnable, long latestTime) {
        if (runnable != null) {
            boolean finished = false;
            while (!finished && System.currentTimeMillis() < latestTime && this.isAlive() && !Thread.currentThread().isInterrupted()) {
                long timeout = Math.min(1000L, latestTime - System.currentTimeMillis());
                if (timeout < 1L) {
                    timeout = 1L;
                }
                finished = runnable.await(timeout);
            }
        }
    }

    private Process createWindowsShellProcess(List<String> command, Map<String, String> environment, File workingDir) throws IOException {
        ArrayList<String> newCommand = new ArrayList<String>(command.size() + 4);
        newCommand.add("cmd.exe");
        newCommand.add("/A");
        newCommand.add("/C");
        newCommand.add("call");
        newCommand.addAll(command);
        return this.createDefaultProcess(newCommand, environment, workingDir);
    }

    private String escapeArgument(String s) {
        String escapedArg = s;
        if (s.contains("\"") && !this.leadingAndTrailingQuotesOnly(s)) {
            boolean escapeNextChar = false;
            boolean isQuoted = this.leadingAndTrailingQuotes(s);
            if (isQuoted) {
                s = s.substring(1, s.length() - 1);
            }
            StringBuilder sb = new StringBuilder(isQuoted ? "\"" : "");
            for (char c : s.toCharArray()) {
                if (escapeNextChar) {
                    escapeNextChar = false;
                } else if (c == '\"') {
                    sb.append('\\');
                } else if (c == '\\') {
                    escapeNextChar = true;
                }
                sb.append(c);
            }
            if (escapeNextChar) {
                sb.append('\\');
            }
            if (isQuoted) {
                sb.append('\"');
            }
            escapedArg = sb.toString();
        }
        return escapedArg;
    }

    private void handleHandlerError(String handlerName, Throwable t) {
        if (!this.isCanceled()) {
            if (this.isAlive()) {
                log.debug((Object)(handlerName + " encountered an error; aborting process"), t);
                this.cancel();
            }
            this.processException = t instanceof ProcessException ? (ProcessException)t : new ProcessException(t);
        } else {
            log.debug((Object)(handlerName + ": Process canceled; ignoring exception"), t);
        }
    }

    private void handleProcessInterrupted() {
        if (!this.isCanceled()) {
            if (this.isAlive()) {
                log.debug((Object)"The process was interrupted; aborting the process");
                this.cancel();
            }
            this.processException = new ProcessException("Interrupted while waiting for process to finish");
        }
    }

    private synchronized void internalCancel(boolean completedSuccessfully) {
        if (this.inputPump != null) {
            this.inputPumpInterruptedAfterProcessFinished = !this.isAlive() && this.inputPump.isRunning();
            this.inputPump.cancel();
            this.inputPump = null;
        }
        if (this.outputPump != null) {
            this.outputPump.cancel();
            this.outputPump = null;
        }
        if (this.errorPump != null) {
            this.errorPump.cancel();
            this.errorPump = null;
        }
        if (this.process != null) {
            if (this.isWindows() && !completedSuccessfully) {
                try {
                    new WinProcess(this.process).killRecursively();
                }
                catch (Throwable t) {
                    log.warn((Object)"Failed to kill Windows process; falling back on Process.destroy()", t);
                    this.process.destroy();
                }
            } else {
                this.process.destroy();
            }
        }
    }

    private boolean isWindowsShellFile(List<String> command) {
        if (!command.isEmpty()) {
            String binary = command.get(0).toUpperCase();
            return binary.endsWith(".BAT") || binary.endsWith(".CMD");
        }
        return false;
    }

    private boolean leadingAndTrailingQuotesOnly(String s) {
        return this.leadingAndTrailingQuotes(s) && s.indexOf(34, 1) == s.length() - 1;
    }

    private boolean leadingAndTrailingQuotes(String s) {
        return s.length() > 1 && s.startsWith("\"") && s.endsWith("\"");
    }

    private void logProcessDetails(ProcessBuilder processBuilder) {
        String divider = "---------------------------";
        log.debug((Object)divider);
        log.debug((Object)"Start Process Debug Information");
        log.debug((Object)divider);
        log.debug((Object)"Command");
        log.debug(processBuilder.command());
        log.debug((Object)divider);
        log.debug((Object)"Working Dir");
        log.debug((Object)processBuilder.directory());
        log.debug((Object)divider);
        log.debug((Object)"Environment");
        for (Map.Entry<String, String> entry : processBuilder.environment().entrySet()) {
            String key = entry.getKey();
            boolean sanitize = key != null && key.toLowerCase().contains("password");
            log.debug((Object)(key + ": " + (sanitize ? "*******" : entry.getValue())));
        }
        log.debug((Object)divider);
        log.debug((Object)"Redirect Error Stream?");
        log.debug((Object)processBuilder.redirectErrorStream());
        log.debug((Object)divider);
        log.debug((Object)"End Process Debug Information");
        log.debug((Object)divider);
    }

    private void notifyBeforeStart() {
        for (ProcessMonitor monitor : this.monitors) {
            try {
                monitor.onBeforeStart(this);
            }
            catch (Exception e) {
                log.error((Object)"Error while processing 'beforeStarted' event:", (Throwable)e);
            }
        }
    }

    private void notifyAfterFinished() {
        for (ProcessMonitor monitor : this.monitors) {
            try {
                monitor.onAfterFinished(this);
            }
            catch (Exception e) {
                log.error((Object)"Error while processing 'afterFinished' event:", (Throwable)e);
            }
        }
    }

    private void setupIOPumps() {
        String command = this.command.get(0);
        if (this.handler.hasInput()) {
            this.inputPump = new InputHandlerRunnable(command);
        }
        this.errorPump = new ErrorHandlerRunnable(command);
        this.outputPump = this.asynchronous ? new AsynchronousOutputHandlerRunnable(command) : new OutputHandlerRunnable(command);
        this.resetWatchdog();
        this.handler.setWatchdog(this);
        this.executorService.execute(this.errorPump);
        this.executorService.execute(this.outputPump);
        if (this.inputPump != null) {
            this.executorService.execute(this.inputPump);
        }
    }

    private boolean shouldIgnoreInputPumpException(Throwable t) {
        if (this.inputPumpInterruptedAfterProcessFinished) {
            while (t != null) {
                if (t instanceof InterruptedException || t instanceof InterruptedIOException) {
                    return true;
                }
                t = t.getCause();
            }
        }
        return false;
    }

    private synchronized void wrapUpProcess() {
        if (this.finished) {
            return;
        }
        Optional<Object> exitCode = Optional.empty();
        boolean interrupted = false;
        if (this.process != null) {
            try {
                exitCode = this.getExitCodeUnlessTimeout(this.process);
            }
            catch (InterruptedException ie) {
                interrupted = true;
            }
        }
        boolean completedSuccessfully = exitCode.orElse(-1) == 0;
        this.internalCancel(completedSuccessfully);
        if (this.processException == null && !exitCode.isPresent() && !interrupted) {
            this.processException = new ProcessTimeoutException("process timed out");
        }
        this.handler.complete((Integer)exitCode.orElse(-1), this.isCanceled(), this.processException);
        this.finished = true;
        this.notifyAfterFinished();
    }

    private Optional<Integer> getExitCodeUnlessTimeout(Process process) throws InterruptedException {
        long timeToWait;
        do {
            if (!process.waitFor(Math.max(timeToWait = this.getTimeoutTime() - System.currentTimeMillis() + 10L, 1L), TimeUnit.MILLISECONDS)) continue;
            return Optional.of(process.exitValue());
        } while (timeToWait > 0L);
        return Optional.empty();
    }

    private class OutputHandlerRunnable
    extends AbstractHandlerRunnable {
        public OutputHandlerRunnable(String command) {
            super("StdOutHandler [" + command + ']');
        }

        @Override
        protected void process() throws Throwable {
            ExternalProcessImpl.this.handler.processOutput(ExternalProcessImpl.this.process.getInputStream());
        }
    }

    private class InputHandlerRunnable
    extends AbstractHandlerRunnable {
        public InputHandlerRunnable(String command) {
            super("StdInHandler [" + command + ']');
        }

        @Override
        protected void onError(Throwable t) {
            if (!ExternalProcessImpl.this.shouldIgnoreInputPumpException(t)) {
                super.onError(t);
            }
        }

        @Override
        protected void process() throws Throwable {
            ExternalProcessImpl.this.handler.provideInput(ExternalProcessImpl.this.process.getOutputStream());
        }
    }

    private class ErrorHandlerRunnable
    extends AbstractHandlerRunnable {
        public ErrorHandlerRunnable(String command) {
            super("StdErrHandler [" + command + ']');
        }

        @Override
        protected void process() throws Throwable {
            ExternalProcessImpl.this.handler.processError(ExternalProcessImpl.this.process.getErrorStream());
        }
    }

    private class AsynchronousOutputHandlerRunnable
    extends OutputHandlerRunnable {
        public AsynchronousOutputHandlerRunnable(String command) {
            super(command);
        }

        @Override
        public void run() {
            try {
                super.run();
            }
            finally {
                this.maybeFinish();
            }
        }

        private void maybeFinish() {
            try {
                ExternalProcessImpl.this.finish(10);
            }
            catch (Throwable t) {
                log.warn((Object)("Finishing " + ExternalProcessImpl.this.getCommandLine() + " finished"), t);
            }
        }
    }

    private abstract class AbstractHandlerRunnable
    extends LatchedRunnable {
        protected AbstractHandlerRunnable(String name) {
            super(name);
        }

        @Override
        protected void doTask() {
            try {
                this.process();
            }
            catch (Throwable t) {
                this.onError(t);
            }
        }

        protected void onError(Throwable t) {
            ExternalProcessImpl.this.handleHandlerError(this.getName(), t);
        }

        protected abstract void process() throws Throwable;
    }
}

