/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.utils.process;

import java.util.Stack;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;

public abstract class LatchedRunnable
implements Runnable {
    private static final Logger log = Logger.getLogger(LatchedRunnable.class);
    private final CountDownLatch latch;
    private final Stack<?> ndcStack;
    private final AtomicReference<Thread> runner;
    @Deprecated
    protected String name;
    private volatile boolean canceled;

    @Deprecated
    protected LatchedRunnable() {
        this("LatchedRunnable");
    }

    protected LatchedRunnable(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.trim().isEmpty()) {
            throw new IllegalArgumentException("A name is required for each LatchedRunnable");
        }
        this.name = name;
        this.latch = new CountDownLatch(1);
        this.ndcStack = NDC.cloneStack();
        this.runner = new AtomicReference();
    }

    public boolean await(long millis) {
        return this.await(millis, TimeUnit.MILLISECONDS);
    }

    public boolean await(long value, TimeUnit unit) {
        try {
            return this.latch.await(value, unit);
        }
        catch (InterruptedException e) {
            log.warn((Object)"Interrupted waiting for ExternalProcess pump to complete");
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public void cancel() {
        this.canceled = true;
        this.interrupt();
    }

    public String getName() {
        return this.name;
    }

    public void interrupt() {
        Thread runnerThread = this.runner.get();
        if (runnerThread != null) {
            runnerThread.interrupt();
        }
    }

    @Deprecated
    public boolean isCancelled() {
        return this.canceled;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean isRunning() {
        return this.latch.getCount() > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            NDC.inherit(this.ndcStack);
            this.runner.set(Thread.currentThread());
            this.doTask();
        }
        finally {
            this.runner.set(null);
            NDC.remove();
            this.latch.countDown();
        }
    }

    protected abstract void doTask();
}

