/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.utils.process;

import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.LatchedRunnable;
import com.atlassian.utils.process.ProcessException;
import com.atlassian.utils.process.ProcessHandler;
import com.atlassian.utils.process.ProcessMonitor;
import com.atlassian.utils.process.ProcessTimeoutException;
import com.atlassian.utils.process.ProcessUtils;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.jvnet.winp.WinProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalProcessImpl
implements ExternalProcess {
    private static final Logger LOG = Logger.getLogger(ExternalProcessImpl.class);
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase();
    private final AtomicBoolean canceled = new AtomicBoolean(false);
    private final List<String> command;
    private Map<String, String> environment;
    private volatile LatchedRunnable errorPump;
    private final ExecutorService executorService;
    private volatile long executionTimeout;
    private final AtomicBoolean finished = new AtomicBoolean(false);
    private volatile ProcessHandler handler;
    private volatile long idleTimeout;
    private volatile LatchedRunnable inputPump;
    private volatile boolean inputPumpInterruptedAfterProcessFinished = false;
    private volatile long lastWatchdogReset;
    private final List<ProcessMonitor> monitors;
    private volatile LatchedRunnable outputPump;
    private volatile Process process;
    private ProcessException processException;
    private boolean suppressSpecialWindowsBehaviour;
    private volatile long startTime;
    private File workingDir;
    private boolean useWindowsEncodingWorkaround;
    private boolean runWithPowershell;

    public ExternalProcessImpl(ExecutorService executorService, String[] command, ProcessHandler handler) {
        this(executorService, Arrays.asList(command), handler);
    }

    public ExternalProcessImpl(ExecutorService executorService, List<String> command, ProcessHandler handler) {
        this.command = command;
        this.setHandler(handler);
        this.executorService = executorService;
        this.idleTimeout = TimeUnit.MINUTES.toMillis(1L);
        this.monitors = new CopyOnWriteArrayList<ProcessMonitor>();
        this.startTime = -1L;
    }

    public ExternalProcessImpl(ExecutorService executorService, String commandLine, ProcessHandler handler) {
        this(executorService, ProcessUtils.tokenizeCommand(commandLine), handler);
    }

    @Override
    public void resetWatchdog() {
        this.lastWatchdogReset = System.currentTimeMillis();
    }

    public long getTimeoutTime() {
        long timeout = this.lastWatchdogReset + this.idleTimeout;
        if (this.executionTimeout > 0L && this.startTime > 0L) {
            timeout = Math.min(timeout, this.startTime + this.executionTimeout);
        }
        return timeout;
    }

    public boolean isTimedOut() {
        return this.getTimeoutTime() < System.currentTimeMillis();
    }

    protected void setHandler(ProcessHandler handler) {
        this.handler = handler;
    }

    public void setWorkingDir(File workingDir) {
        this.workingDir = workingDir;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment = environment;
    }

    public void setSuppressSpecialWindowsBehaviour(boolean suppressSpecialWindowsBehaviour) {
        this.suppressSpecialWindowsBehaviour = suppressSpecialWindowsBehaviour;
    }

    public void setUseWindowsEncodingWorkaround(boolean useWindowsEncodingWorkaround) {
        this.useWindowsEncodingWorkaround = useWindowsEncodingWorkaround;
    }

    public void setRunWithPowershell(boolean runWithPowershell) {
        this.runWithPowershell = runWithPowershell;
    }

    private boolean areOutputPumpsRunning() {
        return this.outputPump != null && this.outputPump.isRunning() || this.errorPump != null && this.errorPump.isRunning();
    }

    @Override
    public ProcessHandler getHandler() {
        return this.handler;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    public void addMonitor(ProcessMonitor monitor) {
        this.monitors.add(monitor);
    }

    public void removeMonitor(ProcessMonitor monitor) {
        this.monitors.remove(monitor);
    }

    private boolean isWindows() {
        return OS_NAME.contains("windows");
    }

    private String quoteString(String value) {
        StringBuilder builder = new StringBuilder().append("\"").append(value.replace("\"", "\\\"")).append("\"");
        return builder.toString();
    }

    private Process createWinProcess(List<String> command, Map<String, String> environment, File workingDir) throws IOException {
        ArrayList<String> newCommand = new ArrayList<String>(command.size() + 4);
        if (this.runWithPowershell) {
            newCommand.add("powershell");
            newCommand.add("-Command");
        } else {
            newCommand.add("cmd");
            newCommand.add("/A");
            newCommand.add("/C");
            newCommand.add("call");
        }
        if (this.useWindowsEncodingWorkaround) {
            newCommand.add(command.get(0));
            HashMap<String, String> i18nEnvironment = environment == null ? new HashMap<String, String>() : new HashMap<String, String>(environment);
            for (int counter = 1; counter < command.size(); ++counter) {
                String envName = "JENV_" + counter;
                newCommand.add("%" + envName + "%");
                i18nEnvironment.put(envName, this.quoteString(command.get(counter)));
            }
            environment = i18nEnvironment;
        } else {
            newCommand.addAll(command);
        }
        ProcessBuilder builder = new ProcessBuilder(newCommand).directory(workingDir);
        if (environment != null) {
            builder.environment().putAll(environment);
        }
        if (LOG.isDebugEnabled()) {
            this.logProcessDetails(builder);
        }
        return builder.start();
    }

    protected Process createProcess(List<String> command, Map<String, String> environment, File workingDir) throws IOException {
        if (!this.suppressSpecialWindowsBehaviour && this.isWindows()) {
            return this.createWinProcess(command, environment, workingDir);
        }
        ProcessBuilder builder = new ProcessBuilder(command).directory(workingDir);
        if (environment != null) {
            builder.environment().putAll(environment);
        }
        if (LOG.isDebugEnabled()) {
            this.logProcessDetails(builder);
        }
        return builder.start();
    }

    private void logProcessDetails(ProcessBuilder processBuilder) {
        String divider = "---------------------------";
        LOG.debug((Object)divider);
        LOG.debug((Object)"Start Process Debug Information");
        LOG.debug((Object)divider);
        LOG.debug((Object)"Command");
        LOG.debug(processBuilder.command());
        LOG.debug((Object)divider);
        LOG.debug((Object)"Working Dir");
        LOG.debug((Object)processBuilder.directory());
        LOG.debug((Object)divider);
        LOG.debug((Object)"Environment");
        for (Map.Entry<String, String> entry : processBuilder.environment().entrySet()) {
            LOG.debug((Object)(entry.getKey() + ": " + entry.getValue()));
        }
        LOG.debug((Object)divider);
        LOG.debug((Object)"Redirect Error Stream?");
        LOG.debug((Object)processBuilder.redirectErrorStream());
        LOG.debug((Object)divider);
        LOG.debug((Object)"End Process Debug Information");
        LOG.debug((Object)divider);
    }

    @Override
    public void start() {
        if (this.startTime != -1L) {
            throw new IllegalStateException("An ExternalProcess can only be started once. Create a new instance if you need to rerun a process.");
        }
        try {
            this.startTime = System.currentTimeMillis();
            this.notifyBeforeStart();
            this.process = this.createProcess(this.command, this.environment, this.workingDir);
            this.setupIOPumps();
        }
        catch (IOException e) {
            this.processException = new ProcessException(e);
        }
    }

    private void handleHandlerError(String handlerName, Throwable t) {
        if (!this.isCanceled()) {
            if (this.isAlive()) {
                LOG.debug((Object)(handlerName + " encountered an error; aborting process"), t);
                this.cancel();
            }
            this.processException = t instanceof ProcessException ? (ProcessException)t : new ProcessException(t);
        } else {
            LOG.debug((Object)(handlerName + ": Process canceled; ignoring exception"), t);
        }
    }

    private void setupIOPumps() {
        if (this.handler.hasInput()) {
            this.inputPump = new LatchedRunnable("StdInHandler " + this.process){

                protected void doTask() {
                    block3: {
                        try {
                            ExternalProcessImpl.this.handler.provideInput(ExternalProcessImpl.this.process.getOutputStream());
                            if (ExternalProcessImpl.this.runWithPowershell) {
                                ExternalProcessImpl.this.process.getOutputStream().close();
                            }
                        }
                        catch (Throwable t) {
                            if (ExternalProcessImpl.this.shouldIgnoreInputPumpException(t)) break block3;
                            ExternalProcessImpl.this.handleHandlerError(this.name, t);
                        }
                    }
                }
            };
        } else if (this.runWithPowershell) {
            try {
                this.process.getOutputStream().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.errorPump = new LatchedRunnable("StdErrHandler " + this.process){

            protected void doTask() {
                try {
                    ExternalProcessImpl.this.handler.processError(ExternalProcessImpl.this.process.getErrorStream());
                }
                catch (Throwable t) {
                    ExternalProcessImpl.this.handleHandlerError(this.name, t);
                }
            }
        };
        this.outputPump = new LatchedRunnable("StdOutHandler " + this.process){

            protected void doTask() {
                try {
                    ExternalProcessImpl.this.handler.processOutput(ExternalProcessImpl.this.process.getInputStream());
                }
                catch (Throwable t) {
                    ExternalProcessImpl.this.handleHandlerError(this.name, t);
                }
            }
        };
        this.resetWatchdog();
        this.handler.setWatchdog(this);
        this.executorService.execute(this.errorPump);
        this.executorService.execute(this.outputPump);
        if (this.inputPump != null) {
            this.executorService.execute(this.inputPump);
        }
    }

    private void notifyBeforeStart() {
        for (ProcessMonitor monitor : this.monitors) {
            try {
                monitor.onBeforeStart(this);
            }
            catch (Exception e) {
                LOG.error((Object)"Error while processing 'beforeStarted' event:", (Throwable)e);
            }
        }
    }

    private void notifyAfterFinished() {
        for (ProcessMonitor monitor : this.monitors) {
            try {
                monitor.onAfterFinished(this);
            }
            catch (Exception e) {
                LOG.error((Object)"Error while processing 'afterFinished' event:", (Throwable)e);
            }
        }
    }

    @Override
    public String getCommandLine() {
        StringBuilder builder = new StringBuilder();
        for (String s : this.command) {
            if (builder.length() > 0) {
                builder.append(" ");
            }
            builder.append(s);
        }
        return builder.toString();
    }

    @Override
    public void execute() {
        this.start();
        this.finish();
    }

    @Override
    public void executeWhile(Runnable runnable) {
        this.start();
        if (runnable != null) {
            runnable.run();
        }
        this.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish() {
        if (this.process == null || this.finished.get()) {
            return;
        }
        try {
            do {
                long checkTime = this.getTimeoutTime();
                this.awaitPump(this.outputPump, checkTime);
                this.awaitPump(this.errorPump, checkTime);
                this.awaitPumpOrProcess(this.inputPump, checkTime);
            } while (!this.isTimedOut() && this.areOutputPumpsRunning() && !Thread.currentThread().isInterrupted());
        }
        finally {
            if (Thread.currentThread().isInterrupted()) {
                this.cancel();
                Thread.interrupted();
            }
            this.wrapUpProcess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean finish(int maxWait) {
        if (this.process == null || this.finished.get()) {
            return true;
        }
        long endTime = System.currentTimeMillis() + (long)maxWait;
        try {
            do {
                long checkTime = Math.min(endTime, this.getTimeoutTime());
                this.awaitPump(this.outputPump, checkTime);
                this.awaitPump(this.errorPump, checkTime);
                this.awaitPumpOrProcess(this.inputPump, checkTime);
            } while (System.currentTimeMillis() < endTime && !this.isTimedOut() && this.areOutputPumpsRunning() && !Thread.currentThread().isInterrupted());
        }
        finally {
            if (!this.areOutputPumpsRunning() || !this.isAlive()) {
                this.wrapUpProcess();
            }
        }
        return this.finished.get();
    }

    private boolean shouldIgnoreInputPumpException(Throwable t) {
        if (this.inputPumpInterruptedAfterProcessFinished) {
            while (t != null) {
                if (t instanceof InterruptedException || t instanceof InterruptedIOException) {
                    return true;
                }
                t = t.getCause();
            }
        }
        return false;
    }

    private void wrapUpProcess() {
        if (this.process == null || this.finished.get()) {
            return;
        }
        int exitCode = -1;
        boolean processIncomplete = true;
        boolean interrupted = false;
        try {
            exitCode = this.process.exitValue();
            processIncomplete = false;
        }
        catch (IllegalThreadStateException itse) {
            while (processIncomplete && System.currentTimeMillis() - this.getTimeoutTime() < 10L) {
                try {
                    Thread.sleep(100L);
                    exitCode = this.process.exitValue();
                    processIncomplete = false;
                }
                catch (InterruptedException ie) {
                    processIncomplete = true;
                    interrupted = true;
                    break;
                }
                catch (IllegalThreadStateException e) {
                }
            }
        }
        if (this.finished.compareAndSet(false, true)) {
            this.internalCancel(exitCode);
            if (processIncomplete && !interrupted) {
                this.processException = new ProcessTimeoutException("process timed out");
            }
            this.handler.complete(exitCode, this.isCanceled(), this.processException);
            this.notifyAfterFinished();
        }
    }

    private void awaitPumpOrProcess(LatchedRunnable runnable, long latestTime) {
        if (runnable != null) {
            boolean finished = false;
            while (!finished && System.currentTimeMillis() < latestTime && this.isAlive() && !Thread.currentThread().isInterrupted()) {
                long timeout = Math.min(1000L, latestTime - System.currentTimeMillis());
                if (timeout < 1L) {
                    timeout = 1L;
                }
                finished = runnable.await(timeout);
            }
        }
    }

    private void awaitPump(LatchedRunnable runnable, long latestTime) {
        if (runnable != null) {
            long timeout = latestTime - System.currentTimeMillis();
            if (timeout < 1L) {
                timeout = 1L;
            }
            runnable.await(timeout);
        }
    }

    @Override
    public void cancel() {
        if (this.canceled.compareAndSet(false, true)) {
            this.internalCancel(1);
        }
    }

    private synchronized void internalCancel(int exitCode) {
        if (this.inputPump != null) {
            this.inputPumpInterruptedAfterProcessFinished = !this.isAlive() && this.inputPump.isRunning();
            this.inputPump.cancel();
            this.inputPump = null;
        }
        if (this.outputPump != null) {
            this.outputPump.cancel();
            this.outputPump = null;
        }
        if (this.errorPump != null) {
            this.errorPump.cancel();
            this.errorPump = null;
        }
        if (this.process != null) {
            if (this.isWindows() && exitCode != 0) {
                try {
                    new WinProcess(this.process).killRecursively();
                }
                catch (Throwable t) {
                    LOG.warn((Object)"Failed to kill Windows process; falling back on Process.destroy()", t);
                    this.process.destroy();
                }
            } else {
                this.process.destroy();
            }
        }
    }

    @Override
    public boolean isCanceled() {
        return this.canceled.get();
    }

    @Override
    public boolean isAlive() {
        try {
            if (this.process != null) {
                this.process.exitValue();
            }
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
        return false;
    }

    public void setExecutionTimeout(long executionTimeout) {
        this.executionTimeout = executionTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    @Deprecated
    public void setTimeout(long timeout) {
        this.setIdleTimeout(timeout);
    }
}

