/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.utils.process;

import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.ExternalProcessFactory;
import com.atlassian.utils.process.ExternalProcessImpl;
import com.atlassian.utils.process.ExternalProcessSettings;
import com.atlassian.utils.process.LatchedRunnable;
import com.atlassian.utils.process.ProcessMonitor;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class DefaultExternalProcessFactory
implements ExternalProcessFactory {
    private static final Logger LOG = Logger.getLogger(DefaultExternalProcessFactory.class);
    private final ExecutorService pool;
    private boolean shutdown;

    public DefaultExternalProcessFactory() {
        this(DefaultExternalProcessFactory.createDefaultExecutorService());
    }

    public DefaultExternalProcessFactory(ExecutorService executorService) {
        this.pool = executorService;
    }

    private static ExecutorService createDefaultExecutorService() {
        String pooledThreadName = "ExtProcess IO Pump";
        ThreadFactory threadFactory = new ThreadFactory(){

            public Thread newThread(Runnable r) {
                return new Thread(r, "ExtProcess IO Pump");
            }
        };
        return new ThreadPoolExecutor(6, Integer.MAX_VALUE, 2L, TimeUnit.MINUTES, (BlockingQueue)new SynchronousQueue(), threadFactory){

            protected void beforeExecute(Thread thread, Runnable runnable) {
                thread.setName(thread.getId() + ":" + ((LatchedRunnable)runnable).getName());
                super.beforeExecute(thread, runnable);
            }

            protected void afterExecute(Runnable runnable, Throwable throwable) {
                Thread.currentThread().setName("ExtProcess IO Pump");
                super.afterExecute(runnable, throwable);
            }
        };
    }

    public ExternalProcess create(ExternalProcessSettings settings) {
        if (this.shutdown) {
            throw new IllegalStateException("The DefaultExternalProcessFactory has been shutdown; new external processes cannot be created");
        }
        settings.validate();
        ExternalProcessImpl process = new ExternalProcessImpl(this.pool, settings.getCommand(), settings.getProcessHandler());
        this.configureProcess(process, settings);
        return process;
    }

    public void shutdown() {
        this.shutdown = true;
        if (this.pool == null) {
            return;
        }
        LOG.debug((Object)"Attempting to shutdown pump executor service");
        this.pool.shutdown();
        try {
            if (this.pool.awaitTermination(5L, TimeUnit.SECONDS)) {
                LOG.debug((Object)"Pump executor service has shutdown gracefully");
            } else {
                LOG.warn((Object)"Pump executor service did not shutdown within the timeout; forcing shutdown");
                this.pool.shutdownNow();
                if (this.pool.awaitTermination(5L, TimeUnit.SECONDS)) {
                    LOG.debug((Object)"Pump executor service has been forced to shutdown");
                } else {
                    LOG.warn((Object)"Pump executor service did not shutdown; it will be abandoned");
                }
            }
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"Interrupted while waiting for the pump executor service to shutdown; some worker threads may still be running");
        }
    }

    protected void configureProcess(ExternalProcessImpl process, ExternalProcessSettings settings) {
        process.setSuppressSpecialWindowsBehaviour(settings.isSuppressSpecialWindowsBehaviour());
        process.setUseWindowsEncodingWorkaround(settings.isUseWindowsEncodingWorkaround());
        process.setWorkingDir(settings.getWorkingDirectory());
        for (ProcessMonitor monitor : settings.getMonitors()) {
            if (monitor == null) {
                throw new IllegalArgumentException("Null ProcessMonitor in the monitors collection");
            }
            process.addMonitor(monitor);
        }
        if (settings.hasEnvironment()) {
            process.setEnvironment(settings.getEnvironment());
        }
        if (settings.hasExecutionTimeout()) {
            process.setExecutionTimeout(settings.getExecutionTimeout());
        }
        if (settings.hasIdleTimeout()) {
            process.setIdleTimeout(settings.getIdleTimeout());
        }
        process.setRunWithPowershell(settings.isRunWithPowershell());
    }
}

