/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.utils.process;

import java.util.Stack;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;

public abstract class LatchedRunnable
implements Runnable {
    private static Logger log = Logger.getLogger(LatchedRunnable.class);
    private CountDownLatch latch = new CountDownLatch(1);
    private Thread runner;
    private boolean cancelled;
    private Stack<?> ndcStack = NDC.cloneStack();
    protected String name;

    protected LatchedRunnable() {
    }

    protected LatchedRunnable(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        try {
            NDC.inherit(this.ndcStack);
            this.runner = Thread.currentThread();
            this.doTask();
        }
        finally {
            this.latch.countDown();
            NDC.remove();
            this.runner = null;
        }
    }

    public boolean await(long millis) {
        try {
            return this.latch.await(millis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            log.warn((Object)"Interrupted waiting for ExternalProcess pump to complete");
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public boolean isRunning() {
        return this.latch.getCount() > 0L;
    }

    protected abstract void doTask();

    public void interrupt() {
        if (this.runner != null) {
            this.runner.interrupt();
        }
    }

    public void cancel() {
        this.cancelled = true;
        this.interrupt();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public String getName() {
        return this.name;
    }
}

