/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.utils.process;

import com.atlassian.utils.process.BaseProcessHandler;
import com.atlassian.utils.process.InputHandler;
import com.atlassian.utils.process.OutputHandler;
import com.atlassian.utils.process.ProcessException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class PluggableProcessHandler
extends BaseProcessHandler {
    private int exitCode;
    private ProcessException exception;
    private OutputHandler outputHandler;
    private OutputHandler errorHandler;
    private InputHandler inputHandler;
    private boolean complete;
    private boolean throwOnNonZeroExit = true;
    private static final Logger LOGGER = Logger.getLogger(PluggableProcessHandler.class);

    public void processOutput(InputStream processOutput) throws ProcessException {
        if (this.outputHandler == null) {
            throw new IllegalStateException("Process output received with no handler");
        }
        this.outputHandler.setWatchdog(this.getWatchdog());
        this.outputHandler.process(processOutput);
    }

    public void processError(InputStream processError) throws ProcessException {
        if (this.errorHandler == null) {
            throw new IllegalStateException("Process error output received with no handler");
        }
        this.errorHandler.setWatchdog(this.getWatchdog());
        this.errorHandler.process(processError);
    }

    public boolean hasInput() {
        return this.inputHandler != null;
    }

    public void provideInput(OutputStream processInput) {
        if (!this.hasInput()) {
            throw new IllegalStateException("Attempt to read input without an input handler");
        }
        this.inputHandler.setWatchdog(this.getWatchdog());
        this.inputHandler.process(processInput);
    }

    public void complete(int code, ProcessException pe) {
        this.exitCode = code;
        this.exception = pe;
        if (this.outputHandler != null) {
            try {
                this.outputHandler.complete();
            }
            catch (Throwable e) {
                this.setException(e);
            }
        }
        if (this.errorHandler != null) {
            try {
                this.errorHandler.complete();
            }
            catch (Throwable e) {
                this.setException(e);
            }
        }
        if (this.inputHandler != null) {
            try {
                this.inputHandler.complete();
            }
            catch (Throwable e) {
                this.setException(e);
            }
        }
        if (pe == null && code != 0 && this.throwOnNonZeroExit) {
            this.setException(new ProcessException("Non-zero exit code: " + code, code));
        }
        this.complete = true;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public ProcessException getException() {
        return this.exception;
    }

    public void setException(Throwable e) {
        if (this.exception == null) {
            this.exception = e instanceof ProcessException ? (ProcessException)e : new ProcessException(e);
        } else {
            LOGGER.debug((Object)"Ignored exception as exception for handler is already set", e);
        }
    }

    public String getError() {
        return null;
    }

    public void setOutputHandler(OutputHandler outputHandler) {
        this.outputHandler = outputHandler;
    }

    public void setErrorHandler(OutputHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setInputHandler(InputHandler inputHandler) {
        this.inputHandler = inputHandler;
    }

    public OutputHandler getOutputHandler() {
        return this.outputHandler;
    }

    public OutputHandler getErrorHandler() {
        return this.errorHandler;
    }

    public InputHandler getInputHandler() {
        return this.inputHandler;
    }

    public boolean succeeded() {
        return this.exception == null;
    }

    public void reset() {
        this.exitCode = 0;
        this.exception = null;
        this.complete = false;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isThrowOnNonZeroExit() {
        return this.throwOnNonZeroExit;
    }

    public void setThrowOnNonZeroExit(boolean throwOnNonZeroExit) {
        this.throwOnNonZeroExit = throwOnNonZeroExit;
    }
}

