/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.utils.process;

import com.atlassian.utils.process.BaseOutputHandler;
import com.atlassian.utils.process.LineReadable;
import com.atlassian.utils.process.ProcessException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;

public abstract class LineOutputHandler
extends BaseOutputHandler {
    private final String encoding;

    protected LineOutputHandler() {
        this(null);
    }

    protected LineOutputHandler(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void process(InputStream output) throws ProcessException {
        if (this.encoding == null) {
            this.process(new BufferReaderLineReader(new BufferedReader(new InputStreamReader(output))));
        } else {
            try {
                this.process(new BufferReaderLineReader(new BufferedReader(new InputStreamReader(output, this.encoding))));
            }
            catch (UnsupportedEncodingException e) {
                throw new ProcessException(e);
            }
        }
    }

    protected void process(LineReadable reader) throws ProcessException {
        int counter = 0;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                this.resetWatchdog();
                this.processLine(counter++, line);
            }
            this.processInputEnd(counter);
        }
        catch (InterruptedIOException e) {
            this.processEndByException(counter);
        }
        catch (IOException e) {
            this.processEndByException(counter);
            throw new ProcessException(e);
        }
        finally {
            this.closeQuietly(reader);
        }
    }

    private void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void processEndByException(int counter) {
    }

    protected void processInputEnd(int lineCount) throws ProcessException {
    }

    protected abstract void processLine(int var1, String var2);

    static class BufferReaderLineReader
    implements LineReadable {
        private final BufferedReader reader;

        BufferReaderLineReader(BufferedReader reader) {
            this.reader = reader;
        }

        public String readLine() throws IOException {
            return this.reader.readLine();
        }

        public void close() throws IOException {
            this.reader.close();
        }
    }
}

