/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.contentcache.internal;

import com.atlassian.util.contentcache.CacheAccess;
import com.atlassian.util.contentcache.CacheEntry;
import com.atlassian.util.contentcache.CacheEntryExpiredException;
import com.atlassian.util.contentcache.CacheEntryStatistics;
import com.atlassian.util.contentcache.CacheExpiryStrategy;
import com.atlassian.util.contentcache.CacheResult;
import com.atlassian.util.contentcache.CacheStreamAccess;
import com.atlassian.util.contentcache.ContentProvider;
import com.atlassian.util.contentcache.StreamPumper;
import com.atlassian.util.contentcache.internal.CacheStreamBypass;
import com.atlassian.util.contentcache.internal.CacheWriteState;
import com.atlassian.util.contentcache.internal.DefaultCacheEntryStatistics;
import com.atlassian.util.contentcache.internal.DefaultStreamPump;
import com.atlassian.util.contentcache.internal.util.Closeables;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCacheEntry
implements CacheEntry {
    private static final Logger log = LoggerFactory.getLogger(AbstractCacheEntry.class);
    private static final long MAX_WAIT_FOR_DATA_MS = TimeUnit.MINUTES.toMillis(10L);
    private final Date expiry;
    private final CacheExpiryStrategy expiryStrategy;
    private final Object cacheAccessGuard = new Object();
    private final String key;
    private final String region;
    private final AtomicInteger readers = new AtomicInteger(0);
    private final DefaultCacheEntryStatistics statistics;
    private final Object writeSignal = new Object();
    private volatile Exception cacheWriteException;
    private volatile State state;
    private volatile CacheWriteState writeState;
    private volatile long bytesWritten;

    protected AbstractCacheEntry(@Nonnull String cacheKey, @Nonnull String cacheRegion, Date expiry, @Nonnull CacheExpiryStrategy expiryStrategy) {
        this(cacheKey, cacheRegion, expiry, expiryStrategy, State.NOT_INITIALIZED, CacheWriteState.NOT_STARTED);
    }

    protected AbstractCacheEntry(@Nonnull String cacheKey, @Nonnull String cacheRegion, Date expiry, @Nonnull CacheExpiryStrategy expiryStrategy, @Nonnull State state, @Nonnull CacheWriteState writeState) {
        this.expiry = expiry != null ? new Date(expiry.getTime()) : null;
        this.expiryStrategy = (CacheExpiryStrategy)Preconditions.checkNotNull((Object)expiryStrategy, (Object)"expiryStrategy");
        this.key = (String)Preconditions.checkNotNull((Object)cacheKey, (Object)"cacheKey");
        this.region = (String)Preconditions.checkNotNull((Object)cacheRegion, (Object)"cacheRegion");
        this.state = (State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"state"));
        this.statistics = new DefaultCacheEntryStatistics(cacheKey);
        this.writeState = (CacheWriteState)((Object)Preconditions.checkNotNull((Object)((Object)writeState), (Object)"writeState"));
    }

    @Override
    @Nonnull
    public CacheAccess access(@Nonnull OutputStream outputStream, @Nonnull ContentProvider contentProvider, @Nonnull StreamPumper streamPumper) throws IOException {
        Preconditions.checkNotNull((Object)outputStream, (Object)"outputStream");
        return this.internalAccess(contentProvider, (cacheInputStream, cacheOutputStream) -> new CacheEntryAccess(cacheInputStream, outputStream, cacheOutputStream, contentProvider, streamPumper));
    }

    @Override
    @Nonnull
    public CacheStreamAccess accessStream(@Nonnull ContentProvider contentProvider) throws IOException {
        return this.internalAccess(contentProvider, (cacheInputStream, cacheOutputStream) -> new CacheEntryStreamAccess(cacheInputStream, cacheOutputStream, contentProvider));
    }

    @Override
    public int compareTo(@Nonnull CacheEntry entry) {
        return this.getLastAccessedDate().compareTo(entry.getLastAccessedDate());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractCacheEntry that = (AbstractCacheEntry)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.region, that.region);
    }

    @Override
    public Date getExpiryDate() {
        return this.expiry != null ? new Date(this.expiry.getTime()) : null;
    }

    @Override
    @Nonnull
    public Date getLastAccessedDate() {
        return this.statistics.getLastAccessedDate();
    }

    @Override
    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Override
    public boolean hasReaders() {
        return this.readers.get() > 0;
    }

    @Override
    @Nonnull
    public String getRegion() {
        return this.region;
    }

    @Override
    public long getSize() {
        return this.statistics.getSize();
    }

    public int hashCode() {
        return Objects.hash(this.key, this.region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate() {
        Object object = this.cacheAccessGuard;
        synchronized (object) {
            this.state = State.INVALIDATED;
        }
        log.debug("invalidating cache entry {} (cache has {} readers)", (Object)this.key, (Object)this.readers.get());
        this.cleanUpCacheFileWhenInvalid();
    }

    @Override
    public boolean isValid() {
        return this.state != State.INVALIDATED;
    }

    @Override
    @Nonnull
    public CacheEntryStatistics getStatistics() {
        return this.statistics;
    }

    @Override
    @Nonnull
    public InputStream open(@Nonnull ContentProvider contentProvider) throws IOException {
        return this.accessStream(contentProvider).open();
    }

    @Override
    @Nonnull
    public CacheResult stream(@Nonnull OutputStream outputStream, @Nonnull ContentProvider contentProvider, @Nonnull StreamPumper streamPumper) throws IOException {
        return this.access(outputStream, contentProvider, streamPumper).stream();
    }

    public String toString() {
        return this.getLastAccessedDate().getTime() + "/" + this.region + ":" + this.key;
    }

    protected abstract void doCleanup();

    @Nonnull
    protected abstract InputStream doCreateCacheInputStream() throws IOException;

    @Nonnull
    protected abstract OutputStream doCreateCacheOutputStream() throws IOException;

    private void checkNotExpired() {
        if (this.state != State.INVALIDATED && (!this.isValid() || this.expiryStrategy.isExpired(this))) {
            this.invalidate();
        }
        if (this.state == State.INVALIDATED) {
            throw new CacheEntryExpiredException("CacheEntry has been invalidated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpCacheFileWhenInvalid() {
        if (this.state != State.INVALIDATED || this.readers.get() > 0) {
            return;
        }
        Object object = this.cacheAccessGuard;
        synchronized (object) {
            if (this.state != State.INVALIDATED || this.readers.get() > 0) {
                return;
            }
            this.doCleanup();
            this.statistics.setSize(0L);
        }
    }

    private InputStream getCacheInputStream() throws IOException {
        SyncingInputStream inputStream = new SyncingInputStream(this.doCreateCacheInputStream());
        this.readers.incrementAndGet();
        return new BufferedInputStream(inputStream);
    }

    private OutputStream getCacheOutputStream() throws IOException {
        if (this.state != State.NOT_INITIALIZED) {
            return null;
        }
        try {
            OutputStream delegate = this.doCreateCacheOutputStream();
            this.state = State.AVAILABLE;
            return new BufferedOutputStream(new SyncingOutputStream(delegate));
        }
        catch (Throwable t) {
            this.handleWriteError(t);
            Throwables.propagateIfPossible((Throwable)t, IOException.class);
            Throwables.propagateIfPossible((Throwable)t);
            throw new IOException(t);
        }
    }

    private void handleWriteError(Throwable t) {
        this.invalidate();
        if (t instanceof Exception) {
            this.cacheWriteException = (Exception)t;
        }
        this.setWriteState(CacheWriteState.ERROR);
        log.info("Invalidating cache entry {}. An error occurred while writing to the cache {}", (Object)this.key, (Object)t.getLocalizedMessage());
        log.debug("Error details", t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T internalAccess(ContentProvider contentProvider, CacheAccessFactory<T> factory) throws IOException {
        Preconditions.checkNotNull((Object)contentProvider, (Object)"contentProvider");
        this.checkNotExpired();
        Object object = this.cacheAccessGuard;
        synchronized (object) {
            this.checkNotExpired();
            OutputStream cacheOutputStream = this.getCacheOutputStream();
            InputStream cacheInputStream = this.getCacheInputStream();
            if (cacheOutputStream == null) {
                this.statistics.onCacheHit();
            }
            return factory.create(cacheInputStream, cacheOutputStream);
        }
    }

    private void onReaderFinished() {
        this.readers.decrementAndGet();
        this.cleanUpCacheFileWhenInvalid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setWriteState(CacheWriteState state) {
        Object object = this.writeSignal;
        synchronized (object) {
            this.writeState = state;
            this.writeSignal.notifyAll();
        }
    }

    @ParametersAreNonnullByDefault
    private class SyncingOutputStream
    extends OutputStream {
        private final OutputStream delegate;
        private long lastNotify;

        private SyncingOutputStream(OutputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public void write(int b) throws IOException {
            this.delegate.write(b);
            ++AbstractCacheEntry.this.bytesWritten;
            this.notifyReaders();
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.delegate.write(b);
            AbstractCacheEntry.this.bytesWritten = AbstractCacheEntry.this.bytesWritten + (long)b.length;
            this.notifyReaders();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
            AbstractCacheEntry.this.bytesWritten = AbstractCacheEntry.this.bytesWritten + (long)len;
            this.notifyReaders();
        }

        @Override
        public void close() throws IOException {
            try {
                this.delegate.close();
                super.close();
            }
            finally {
                AbstractCacheEntry.this.statistics.setSize(AbstractCacheEntry.this.bytesWritten);
                this.notifyReaders();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyReaders() {
            if (AbstractCacheEntry.this.writeState != CacheWriteState.WRITING || this.lastNotify + 150L < System.currentTimeMillis()) {
                Object object = AbstractCacheEntry.this.writeSignal;
                synchronized (object) {
                    this.lastNotify = System.currentTimeMillis();
                    AbstractCacheEntry.this.writeSignal.notifyAll();
                }
            }
        }
    }

    private class SyncingInputStream
    extends InputStream {
        private final InputStream delegate;
        private final AtomicBoolean complete;

        private SyncingInputStream(InputStream delegate) {
            this.delegate = delegate;
            this.complete = new AtomicBoolean(false);
        }

        @Override
        public int available() throws IOException {
            return this.delegate.available();
        }

        @Override
        public int read() throws IOException {
            this.maybeWaitForData();
            return this.checkReadComplete(this.delegate.read());
        }

        @Override
        public int read(@Nonnull byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(@Nonnull byte[] b, int off, int len) throws IOException {
            this.maybeWaitForData();
            return this.checkReadComplete(this.delegate.read(b, off, len));
        }

        @Override
        public void close() throws IOException {
            try {
                this.delegate.close();
                super.close();
            }
            finally {
                if (this.complete.compareAndSet(false, true)) {
                    AbstractCacheEntry.this.onReaderFinished();
                }
            }
        }

        private int checkReadComplete(int result) {
            if (result == -1 && this.complete.compareAndSet(false, true)) {
                AbstractCacheEntry.this.onReaderFinished();
            }
            return result;
        }

        private boolean shouldWaitForData() throws IOException {
            return AbstractCacheEntry.this.writeState == CacheWriteState.WRITING && this.available() == 0 || AbstractCacheEntry.this.writeState == CacheWriteState.NOT_STARTED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void maybeWaitForData() {
            block8: {
                try {
                    if (!this.shouldWaitForData()) break block8;
                    Object object = AbstractCacheEntry.this.writeSignal;
                    synchronized (object) {
                        long waitStart = System.currentTimeMillis();
                        while (this.shouldWaitForData()) {
                            if (System.currentTimeMillis() - waitStart >= MAX_WAIT_FOR_DATA_MS) {
                                AbstractCacheEntry.this.invalidate();
                                throw new IllegalStateException("Possible deadlock detected while reading from the cache. Aborting and invalidating the cache entry.");
                            }
                            AbstractCacheEntry.this.writeSignal.wait(MAX_WAIT_FOR_DATA_MS);
                        }
                    }
                }
                catch (IOException e) {
                    log.debug("Error while waiting for data", (Throwable)e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    protected static enum State {
        NOT_INITIALIZED,
        AVAILABLE,
        INVALIDATED;

    }

    private class CacheEntryAccess
    extends BaseAccess
    implements CacheAccess {
        private final StreamPumper streamPumper;
        private final OutputStream outputStream;

        private CacheEntryAccess(InputStream cacheInputStream, OutputStream outputStream, OutputStream cacheOutputStream, ContentProvider contentProvider, StreamPumper pump) {
            super(cacheInputStream, cacheOutputStream, contentProvider);
            this.streamPumper = pump;
            this.outputStream = outputStream;
        }

        @Override
        @Nonnull
        public CacheResult stream() throws IOException {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"CacheAccess has been closed");
            try {
                if (this.cacheInputStream == null) {
                    throw new CacheEntryExpiredException("The cache entry has been invalidated");
                }
                if (AbstractCacheEntry.this.writeState == CacheWriteState.ABORTED) {
                    this.contentProvider.apply(this.outputStream);
                    CacheResult cacheResult = CacheResult.BYPASS;
                    return cacheResult;
                }
                DefaultStreamPump cacheToClientPump = new DefaultStreamPump(this.cacheInputStream, this.outputStream);
                if (this.cacheOutputStream != null) {
                    this.streamPumper.add(cacheToClientPump);
                    this.streamToCache(this.contentProvider, this.cacheOutputStream);
                }
                this.streamPumper.remove(cacheToClientPump);
                cacheToClientPump.pumpAll();
                if (AbstractCacheEntry.this.cacheWriteException != null) {
                    Throwables.propagateIfPossible((Throwable)AbstractCacheEntry.this.cacheWriteException);
                    Throwables.propagateIfInstanceOf((Throwable)AbstractCacheEntry.this.cacheWriteException, IOException.class);
                }
                CacheResult cacheResult = this.getResult();
                return cacheResult;
            }
            finally {
                this.closeStreams();
            }
        }

        @Override
        public void cancel() {
            this.close();
        }
    }

    private class CacheEntryStreamAccess
    extends BaseAccess
    implements CacheStreamAccess {
        private CacheEntryStreamAccess(InputStream cacheInputStream, OutputStream cacheOutputStream, ContentProvider contentProvider) {
            super(cacheInputStream, cacheOutputStream, contentProvider);
        }

        @Override
        @Nonnull
        public InputStream open() throws IOException {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"CacheAccess has been closed");
            try {
                if (this.cacheInputStream == null) {
                    throw new CacheEntryExpiredException("The cache entry has been invalidated");
                }
                if (AbstractCacheEntry.this.writeState == CacheWriteState.ABORTED) {
                    this.closeStreams();
                    InputStream inputStream = new CacheStreamBypass(this.contentProvider).open();
                    return inputStream;
                }
                if (this.cacheOutputStream != null) {
                    this.streamToCache(this.contentProvider, this.cacheOutputStream);
                }
                if (AbstractCacheEntry.this.cacheWriteException != null) {
                    Throwables.propagateIfPossible((Throwable)AbstractCacheEntry.this.cacheWriteException);
                    Throwables.propagateIfInstanceOf((Throwable)AbstractCacheEntry.this.cacheWriteException, IOException.class);
                }
                FilterInputStream filterInputStream = new FilterInputStream(this.cacheInputStream){

                    @Override
                    public void close() throws IOException {
                        CacheEntryStreamAccess.this.closed = true;
                        super.close();
                    }
                };
                return filterInputStream;
            }
            finally {
                Closeables.closeQuietly(this.cacheOutputStream);
            }
        }
    }

    private class BaseAccess
    implements Closeable {
        final InputStream cacheInputStream;
        final OutputStream cacheOutputStream;
        final ContentProvider contentProvider;
        volatile boolean closed;

        private BaseAccess(InputStream cacheInputStream, OutputStream cacheOutputStream, ContentProvider contentProvider) {
            this.cacheInputStream = cacheInputStream;
            this.cacheOutputStream = cacheOutputStream;
            this.contentProvider = contentProvider;
        }

        @Override
        public void close() {
            if (this.cacheOutputStream != null && AbstractCacheEntry.this.writeState == CacheWriteState.NOT_STARTED) {
                AbstractCacheEntry.this.invalidate();
                AbstractCacheEntry.this.setWriteState(CacheWriteState.ABORTED);
            }
            this.closeStreams();
        }

        @Nonnull
        public CacheResult getResult() {
            if (AbstractCacheEntry.this.writeState == CacheWriteState.ABORTED) {
                return CacheResult.BYPASS;
            }
            return this.cacheOutputStream == null ? CacheResult.HIT : CacheResult.MISS;
        }

        void closeStreams() {
            Closeables.closeQuietly(this.cacheOutputStream);
            Closeables.closeQuietly(this.cacheInputStream);
            this.closed = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void streamToCache(ContentProvider contentProvider, OutputStream cacheOutputStream) {
            try {
                Preconditions.checkState((AbstractCacheEntry.this.writeState == CacheWriteState.NOT_STARTED ? 1 : 0) != 0, (String)"Cannot write to the cache - state is %s", (Object[])new Object[]{AbstractCacheEntry.this.writeState.name()});
                AbstractCacheEntry.this.setWriteState(CacheWriteState.WRITING);
                contentProvider.apply(cacheOutputStream);
                cacheOutputStream.flush();
                AbstractCacheEntry.this.setWriteState(CacheWriteState.COMPLETED);
            }
            catch (Throwable t) {
                AbstractCacheEntry.this.handleWriteError(t);
            }
            finally {
                Closeables.closeQuietly(cacheOutputStream);
            }
        }
    }

    private static interface CacheAccessFactory<T> {
        public T create(InputStream var1, OutputStream var2);
    }
}

