/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.contentcache.internal;

import com.atlassian.util.contentcache.CacheStatistics;
import com.atlassian.util.contentcache.ContentCache;
import com.atlassian.util.contentcache.ContentCacheManager;
import com.atlassian.util.contentcache.ContentCacheStatistics;
import com.atlassian.util.contentcache.EvictionStrategy;
import com.atlassian.util.contentcache.StreamPumper;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public abstract class AbstractContentCacheManager
implements ContentCacheManager {
    private final ConcurrentMap<String, ContentCache> caches;
    private final EvictionStrategy evictionStrategy;
    private final StreamPumper pumper;
    private final long cacheExpiryCheckIntervalMillis;
    private volatile long lastCacheExpiredCheckTimestamp;

    protected AbstractContentCacheManager(StreamPumper pumper, @Nonnull EvictionStrategy evictionStrategy, long cacheExpiryCheckIntervalMillis) {
        this.cacheExpiryCheckIntervalMillis = cacheExpiryCheckIntervalMillis;
        this.evictionStrategy = (EvictionStrategy)Preconditions.checkNotNull((Object)evictionStrategy, (Object)"evictionStrategy");
        this.pumper = (StreamPumper)Preconditions.checkNotNull((Object)pumper, (Object)"pumper");
        this.caches = new ConcurrentHashMap<String, ContentCache>();
    }

    @Override
    public void clear() {
        Iterator it = this.caches.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            it.remove();
            ((ContentCache)entry.getValue()).clear();
            this.onCacheRemoved((String)entry.getKey(), (ContentCache)entry.getValue());
        }
    }

    @Override
    public long evict(long bytesToEvict) {
        return this.evictionStrategy.evict(bytesToEvict, this);
    }

    @Override
    @Nonnull
    public ContentCache getCache(@Nonnull String regionKey) {
        Preconditions.checkNotNull((Object)regionKey);
        this.maybePruneExpiredEntries();
        ContentCache cache = (ContentCache)this.caches.get(regionKey);
        while (cache == null) {
            ContentCache newCache = this.createContentCache(regionKey, this.pumper);
            cache = this.caches.putIfAbsent(regionKey, newCache);
            if (cache != null) continue;
            cache = newCache;
            this.onCacheAdded(regionKey, cache);
        }
        return cache;
    }

    public ConcurrentMap<String, ContentCache> getCaches() {
        return this.caches;
    }

    @Override
    public CacheStatistics getStatistics() {
        return new CacheStatistics(){

            @Override
            public long getHits() {
                long hits = 0L;
                for (ContentCache cache : AbstractContentCacheManager.this.caches.values()) {
                    hits += (long)cache.getStatistics().getHits();
                }
                return hits;
            }

            @Override
            public long getMisses() {
                long misses = 0L;
                for (ContentCache cache : AbstractContentCacheManager.this.caches.values()) {
                    misses += (long)cache.getStatistics().getMisses();
                }
                return misses;
            }

            @Override
            @Nonnull
            public Collection<ContentCacheStatistics> getRegions() {
                return AbstractContentCacheManager.this.caches.values().stream().map(ContentCache::getStatistics).collect(Collectors.toList());
            }

            @Override
            public long getSize() {
                long size = 0L;
                for (ContentCache cache : AbstractContentCacheManager.this.caches.values()) {
                    size += cache.getStatistics().getSize();
                }
                return size;
            }
        };
    }

    @Override
    public void remove(@Nonnull String regionKey) {
        ContentCache cache = (ContentCache)this.caches.remove(regionKey);
        if (cache != null) {
            cache.clear();
            this.onCacheRemoved(regionKey, cache);
        }
    }

    public void shutdown() {
        this.pumper.shutdown();
    }

    protected void onCacheAdded(String regionKey, ContentCache cache) {
    }

    protected void onCacheRemoved(String regionKey, ContentCache cache) {
    }

    protected abstract ContentCache createContentCache(String var1, StreamPumper var2);

    private void maybePruneExpiredEntries() {
        long now = System.currentTimeMillis();
        if (this.lastCacheExpiredCheckTimestamp + this.cacheExpiryCheckIntervalMillis < now) {
            this.lastCacheExpiredCheckTimestamp = now;
            this.caches.values().forEach(ContentCache::pruneExpired);
        }
    }
}

