/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.contentcache.internal;

import com.atlassian.util.contentcache.CacheExpiryStrategy;
import com.atlassian.util.contentcache.internal.AbstractCacheEntry;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCacheEntry
extends AbstractCacheEntry {
    private static final Logger log = LoggerFactory.getLogger(FileCacheEntry.class);
    private final File cacheDir;
    private volatile File cacheFile;

    public FileCacheEntry(@Nonnull String cacheKey, @Nonnull String cacheRegion, @Nonnull File cacheDir, Date expiry, @Nonnull CacheExpiryStrategy expiryStrategy) {
        super(cacheKey, cacheRegion, expiry, expiryStrategy);
        this.cacheDir = (File)Preconditions.checkNotNull((Object)cacheDir, (Object)"cacheDir");
        this.createCacheDir();
    }

    @Override
    public boolean isValid() {
        return super.isValid() && (this.cacheFile == null || this.cacheFile.exists());
    }

    @Override
    protected void doCleanup() {
        if (this.cacheFile != null && this.cacheFile.exists() && !this.cacheFile.delete()) {
            this.cacheFile.deleteOnExit();
        }
    }

    @Override
    @Nonnull
    protected InputStream doCreateCacheInputStream() throws IOException {
        Preconditions.checkState((this.cacheFile != null ? 1 : 0) != 0, (Object)"Cache file hasn't been created yet");
        return new FileInputStream(this.cacheFile);
    }

    @Override
    @Nonnull
    protected OutputStream doCreateCacheOutputStream() throws IOException {
        Preconditions.checkState((this.cacheFile == null ? 1 : 0) != 0, (Object)"Cache file has already been created");
        this.cacheFile = this.createCacheFile();
        return new FileOutputStream(this.cacheFile);
    }

    private void createCacheDir() {
        if (!this.cacheDir.exists() && !this.cacheDir.mkdirs()) {
            log.warn("Could not create cache directory {}", (Object)this.cacheDir.getAbsolutePath());
        }
    }

    private File createCacheFile() throws IOException {
        this.createCacheDir();
        return File.createTempFile("cache-entry", "", this.cacheDir);
    }
}

