/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.contentcache.internal;

import com.atlassian.util.contentcache.CacheResult;
import com.atlassian.util.contentcache.CacheStreamAccess;
import com.atlassian.util.contentcache.ContentProvider;
import com.atlassian.util.contentcache.internal.util.PipedStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheStreamBypass
implements CacheStreamAccess {
    private static final Logger log = LoggerFactory.getLogger(CacheStreamBypass.class);
    private final ContentProvider contentProvider;
    private volatile PipedStreams streams;

    public CacheStreamBypass(ContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    @Override
    @Nonnull
    public CacheResult getResult() {
        return CacheResult.BYPASS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public InputStream open() throws IOException {
        if (this.streams == null) {
            CacheStreamBypass cacheStreamBypass = this;
            synchronized (cacheStreamBypass) {
                if (this.streams == null) {
                    this.streams = new PipedStreams(65536);
                    Thread writeThread = new Thread(() -> {
                        try (OutputStream output = this.streams.output();){
                            this.contentProvider.apply(output);
                        }
                        catch (IOException e) {
                            log.warn("Error writing value from ContentProvider {}", (Object)this.contentProvider.getClass().getName(), (Object)e);
                        }
                    }, "cache-bypass-write");
                    writeThread.setDaemon(true);
                    writeThread.start();
                }
            }
        }
        return this.streams.input();
    }

    @Override
    public void close() {
        if (this.streams != null) {
            this.streams.close();
        }
    }
}

