/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.contentcache.internal;

import com.atlassian.util.contentcache.StreamPumper;
import com.atlassian.util.contentcache.internal.AbstractCacheEntry;
import com.atlassian.util.contentcache.internal.AbstractContentCache;
import com.atlassian.util.contentcache.internal.FileCacheEntry;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class FileContentCache
extends AbstractContentCache {
    private static final long MIN_SPACE_WARNING_WAIT = TimeUnit.MINUTES.toMillis(5L);
    private final File cacheDirectory;
    private final long minFreeSpaceBytes;
    private volatile long lastLoggedSpaceWarningTimestamp;

    public FileContentCache(@Nonnull StreamPumper streamPump, @Nonnull String key, @Nonnull File cacheDirectory, long minFreeSpaceBytes) {
        super(streamPump, key);
        Preconditions.checkNotNull((Object)cacheDirectory);
        Preconditions.checkState((cacheDirectory.isDirectory() || cacheDirectory.mkdirs() ? 1 : 0) != 0, (String)"Failed to create cache directory at: {}", (Object[])new Object[]{cacheDirectory.getAbsolutePath()});
        this.cacheDirectory = cacheDirectory;
        this.minFreeSpaceBytes = minFreeSpaceBytes;
    }

    @Override
    protected AbstractCacheEntry newCacheEntry(@Nonnull String cacheKey, @Nonnull Date expiry) throws IOException {
        if (this.cacheDirectory.getFreeSpace() < this.minFreeSpaceBytes) {
            if (this.lastLoggedSpaceWarningTimestamp < System.currentTimeMillis() - MIN_SPACE_WARNING_WAIT) {
                log.warn("SCM level caching is disabled because there is not enough space left on {}", (Object)this.cacheDirectory.getAbsolutePath());
                this.lastLoggedSpaceWarningTimestamp = System.currentTimeMillis();
            }
            return null;
        }
        return new FileCacheEntry(cacheKey, this.cacheDirectory, expiry);
    }
}

