/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.contentcache.internal;

import com.atlassian.util.contentcache.StreamPump;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.locks.ReentrantLock;

class DefaultStreamPump
implements StreamPump {
    private final ReentrantLock lock;
    private final byte[] buffer;
    private final InputStream source;
    private final OutputStream sink;
    private volatile boolean done;
    private volatile Exception exception;

    DefaultStreamPump(InputStream source, OutputStream sink) {
        this.source = (InputStream)Preconditions.checkNotNull((Object)source, (Object)"source");
        this.sink = (OutputStream)Preconditions.checkNotNull((Object)sink, (Object)"sink");
        this.buffer = new byte[4096];
        this.lock = new ReentrantLock(false);
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean maybePumpSome() throws IOException {
        if (this.done || !this.lock.tryLock()) {
            return false;
        }
        try {
            boolean bl = this.source.available() > 0 && this.doPumpSome();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pumpAll() throws IOException {
        if (this.exception != null) {
            Throwables.propagateIfPossible((Throwable)this.exception, IOException.class);
        }
        this.lock.lock();
        try {
            while (this.doPumpSome()) {
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean doPumpSome() throws IOException {
        try {
            int read = this.source.read(this.buffer);
            if (read == -1) {
                this.done = true;
                return false;
            }
            this.sink.write(this.buffer, 0, read);
            this.sink.flush();
            return true;
        }
        catch (Exception e) {
            this.exception = e;
            this.done = true;
            Throwables.propagateIfPossible((Throwable)e, IOException.class);
            return false;
        }
    }
}

