/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.contentcache.internal;

import com.atlassian.util.contentcache.CacheAccess;
import com.atlassian.util.contentcache.CacheEntryExpiredException;
import com.atlassian.util.contentcache.CacheEntryStatistics;
import com.atlassian.util.contentcache.CacheResult;
import com.atlassian.util.contentcache.ContentCache;
import com.atlassian.util.contentcache.ContentCacheStatistics;
import com.atlassian.util.contentcache.ContentProvider;
import com.atlassian.util.contentcache.StreamPumper;
import com.atlassian.util.contentcache.internal.AbstractCacheEntry;
import com.atlassian.util.contentcache.internal.CacheBypass;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContentCache
implements ContentCache {
    protected static final Logger log = LoggerFactory.getLogger(ContentCache.class);
    private final StreamPumper pumper;
    private final ConcurrentMap<String, AbstractCacheEntry> entries;
    private final String key;
    private final Statistics statistics;

    protected AbstractContentCache(@Nonnull StreamPumper pumper, @Nonnull String key) {
        this.pumper = (StreamPumper)Preconditions.checkNotNull((Object)pumper, (Object)"streamPump");
        this.key = (String)Preconditions.checkNotNull((Object)key, (Object)"key");
        this.entries = new ConcurrentHashMap<String, AbstractCacheEntry>();
        this.statistics = new Statistics();
    }

    @Override
    @Nonnull
    public CacheAccess access(@Nonnull String key, @Nonnull OutputStream outputStream, @Nonnull ContentProvider valueProvider) throws IOException {
        int attempts = 0;
        while (attempts++ < 10) {
            AbstractCacheEntry entry = (AbstractCacheEntry)this.entries.get(key);
            if (entry == null) {
                AbstractCacheEntry newEntry = this.newCacheEntry(key, valueProvider.getExpiry());
                if (newEntry == null) {
                    return new CacheBypass(outputStream, valueProvider);
                }
                entry = this.entries.putIfAbsent(key, newEntry);
                if (entry == null) {
                    entry = newEntry;
                    this.onEntryAdded(key, entry);
                    log.debug("Created new cache entry {}", (Object)key);
                }
            }
            try {
                CacheAccess access = entry.access(outputStream, valueProvider, this.pumper);
                if (access.getResult() == CacheResult.HIT) {
                    this.statistics.onHit();
                } else if (access.getResult() == CacheResult.MISS) {
                    this.statistics.onMiss();
                }
                return access;
            }
            catch (CacheEntryExpiredException e) {
                log.debug("Removing expired cache entry {}", (Object)key);
                this.entries.remove(key, entry);
            }
            catch (IOException e) {
                log.debug("Error opening cache entry {}. Invalidating and retrying", (Object)key, (Object)e);
                entry.invalidate();
                this.entries.remove(key, entry);
            }
        }
        log.info("Failed to stream {} through the cache (10 attempts failed) - bypassing the cache.", (Object)key);
        return new CacheBypass(outputStream, valueProvider);
    }

    @Override
    @Nonnull
    public CacheResult stream(@Nonnull String key, @Nonnull OutputStream outputStream, @Nonnull ContentProvider contentProvider) throws IOException {
        return this.access(key, outputStream, contentProvider).stream();
    }

    @Override
    public void clear() {
        Iterator it = this.entries.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            it.remove();
            ((AbstractCacheEntry)entry.getValue()).invalidate();
            this.onEntryRemoved((String)entry.getKey(), (AbstractCacheEntry)entry.getValue());
        }
    }

    @Override
    @Nonnull
    public ContentCacheStatistics getStatistics() {
        return this.statistics;
    }

    @Override
    @Nullable
    public CacheEntryStatistics getStatistics(@Nonnull String key) {
        AbstractCacheEntry entry = (AbstractCacheEntry)this.entries.get(key);
        return entry != null ? entry.getStatistics() : null;
    }

    @Override
    public void pruneExpired() {
        Iterator it = this.entries.values().iterator();
        while (it.hasNext()) {
            AbstractCacheEntry entry = (AbstractCacheEntry)it.next();
            if (!entry.isExpired()) continue;
            entry.invalidate();
            it.remove();
        }
    }

    @Override
    public void remove(@Nonnull String cacheKey) {
        AbstractCacheEntry entry = (AbstractCacheEntry)this.entries.remove(cacheKey);
        if (entry != null) {
            entry.invalidate();
            this.onEntryRemoved(cacheKey, entry);
        }
    }

    @Nullable
    protected abstract AbstractCacheEntry newCacheEntry(@Nonnull String var1, @Nonnull Date var2) throws IOException;

    protected void onEntryAdded(String key, AbstractCacheEntry cacheEntry) {
    }

    protected void onEntryRemoved(String key, AbstractCacheEntry cacheEntry) {
    }

    private class Statistics
    implements ContentCacheStatistics {
        private final AtomicInteger hits = new AtomicInteger(0);
        private final AtomicInteger misses = new AtomicInteger(0);
        private volatile Date lastAccessed = new Date();

        private Statistics() {
        }

        @Override
        @Nonnull
        public Collection<CacheEntryStatistics> getEntries() {
            return ImmutableList.copyOf((Iterable)Iterables.transform(AbstractContentCache.this.entries.values(), AbstractCacheEntry.TO_STATISTICS));
        }

        @Override
        @Nonnull
        public Date getLastAccessedDate() {
            return this.lastAccessed;
        }

        @Override
        public int getHits() {
            return this.hits.get();
        }

        @Override
        @Nonnull
        public String getKey() {
            return AbstractContentCache.this.key;
        }

        @Override
        public int getMisses() {
            return this.misses.get();
        }

        @Override
        public long getSize() {
            long size = 0L;
            for (AbstractCacheEntry entry : AbstractContentCache.this.entries.values()) {
                size += entry.getStatistics().getSize();
            }
            return size;
        }

        public void onHit() {
            this.hits.incrementAndGet();
            this.lastAccessed = new Date();
        }

        public void onMiss() {
            this.misses.incrementAndGet();
            this.lastAccessed = new Date();
        }
    }
}

