/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.contentcache;

import com.atlassian.util.contentcache.AbstractContentCacheManager;
import com.atlassian.util.contentcache.ContentCache;
import com.atlassian.util.contentcache.FileContentCache;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;

public class FileContentCacheManager
extends AbstractContentCacheManager {
    private final File cacheDirectory;

    public FileContentCacheManager(@Nonnull File cacheDirectory) {
        this(new ConcurrentHashMap<String, ContentCache>(), cacheDirectory);
    }

    public FileContentCacheManager(@Nonnull Executor executor, @Nonnull File cacheDirectory) {
        this(new ConcurrentHashMap<String, ContentCache>(), executor, cacheDirectory);
    }

    public FileContentCacheManager(@Nonnull ConcurrentMap<String, ContentCache> caches, @Nonnull File cacheDirectory) {
        this(caches, (Executor)MoreExecutors.sameThreadExecutor(), cacheDirectory);
    }

    public FileContentCacheManager(@Nonnull ConcurrentMap<String, ContentCache> caches, @Nonnull Executor executor, @Nonnull File cacheDirectory) {
        super(caches, executor);
        this.cacheDirectory = (File)Preconditions.checkNotNull((Object)cacheDirectory);
        Preconditions.checkState((cacheDirectory.isDirectory() || cacheDirectory.mkdirs() ? 1 : 0) != 0, (String)"Failed to create directory: {}", (Object[])new Object[]{cacheDirectory.getAbsolutePath()});
    }

    @Override
    protected ContentCache createContentCache(String regionKey, Executor executor) {
        return new FileContentCache(executor, new File(this.cacheDirectory, regionKey));
    }
}

