/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.contentcache;

import com.atlassian.util.contentcache.AbstractContentCache;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FileContentCache
extends AbstractContentCache {
    private final File cacheDirectory;

    public FileContentCache(@Nonnull File cacheDirectory) {
        this(new ConcurrentHashMap<String, AbstractContentCache.CacheEntry>(), cacheDirectory);
    }

    public FileContentCache(@Nonnull Executor executor, @Nonnull File cacheDirectory) {
        this(new ConcurrentHashMap<String, AbstractContentCache.CacheEntry>(), executor, cacheDirectory);
    }

    public FileContentCache(@Nonnull ConcurrentMap<String, AbstractContentCache.CacheEntry> caches, @Nonnull File cacheDirectory) {
        this(caches, (Executor)MoreExecutors.sameThreadExecutor(), cacheDirectory);
    }

    protected FileContentCache(ConcurrentMap<String, AbstractContentCache.CacheEntry> cache, Executor executor, File cacheDirectory) {
        super(cache, executor);
        Preconditions.checkNotNull((Object)cacheDirectory);
        Preconditions.checkState((cacheDirectory.isDirectory() || cacheDirectory.mkdirs() ? 1 : 0) != 0, (String)"Failed to create cache directory at: %s", (Object[])new Object[]{cacheDirectory.getAbsolutePath()});
        this.cacheDirectory = cacheDirectory;
    }

    @Override
    @Nonnull
    protected AbstractContentCache.CacheEntry newCacheEntry(String cacheKey) throws IOException {
        return new FileCacheEntry(this.cacheDirectory, cacheKey);
    }

    protected static class FileCacheEntry
    extends AbstractContentCache.CacheEntry {
        private final File file;
        private final Object writeSignal = new Object();
        private volatile boolean writeCompleted = false;
        private final AtomicInteger readers = new AtomicInteger(0);
        private volatile boolean invalid = false;
        private final Pattern regex = Pattern.compile("\\W");

        public FileCacheEntry(File cacheDirectory, String cacheKey) throws IOException {
            super(cacheKey);
            this.file = File.createTempFile(this.regex.matcher(cacheKey).replaceAll("_"), ".cache", cacheDirectory);
            Preconditions.checkState((this.file.isFile() || this.file.createNewFile() ? 1 : 0) != 0, (String)"Failed to create new file %s", (Object[])new Object[]{this.file.getAbsolutePath()});
        }

        @Override
        @Nullable
        public InputStream getInput() throws IOException {
            this.readers.incrementAndGet();
            if (this.invalid) {
                return null;
            }
            return new FileInputStream(this.file){
                private final AtomicBoolean closed;
                {
                    this.closed = new AtomicBoolean(false);
                }

                @Override
                public int read() throws IOException {
                    this.waitForData();
                    return super.read();
                }

                @Override
                public int read(byte[] bytes) throws IOException {
                    this.waitForData();
                    return super.read(bytes);
                }

                @Override
                public int read(byte[] bytes, int off, int len) throws IOException {
                    this.waitForData();
                    return super.read(bytes, off, len);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        if (this.closed.compareAndSet(false, true)) {
                            FileCacheEntry.this.onReaderFinished();
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                private void waitForData() throws IOException {
                    try {
                        while (!FileCacheEntry.this.writeCompleted && this.available() == 0) {
                            Object object = FileCacheEntry.this.writeSignal;
                            synchronized (object) {
                                FileCacheEntry.this.writeSignal.wait();
                            }
                        }
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
        }

        @Override
        @Nonnull
        public OutputStream getOutput() throws IOException {
            return new FileOutputStream(this.file){
                private long lastNotify;
                {
                    this.lastNotify = 0L;
                }

                @Override
                public void write(byte[] bytes, int off, int len) throws IOException {
                    super.write(bytes, off, len);
                    this.notifyReaders(false);
                }

                @Override
                public void write(int b) throws IOException {
                    super.write(b);
                    this.notifyReaders(false);
                }

                @Override
                public void write(byte[] bytes) throws IOException {
                    super.write(bytes);
                    this.notifyReaders(false);
                }

                @Override
                public void close() throws IOException {
                    super.close();
                    FileCacheEntry.this.writeCompleted = true;
                    this.notifyReaders(true);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void notifyReaders(boolean force) {
                    if (force || this.lastNotify + 50L < System.currentTimeMillis()) {
                        Object object = FileCacheEntry.this.writeSignal;
                        synchronized (object) {
                            this.lastNotify = System.currentTimeMillis();
                            FileCacheEntry.this.writeSignal.notifyAll();
                        }
                    }
                }
            };
        }

        @Override
        public void close() throws IOException {
            this.invalid = true;
            this.cleanUpCacheFileWhenInvalid();
        }

        private void onReaderFinished() {
            this.readers.decrementAndGet();
            this.cleanUpCacheFileWhenInvalid();
        }

        private synchronized void cleanUpCacheFileWhenInvalid() {
            if (this.invalid && this.readers.get() == 0 && this.file.exists()) {
                AbstractContentCache.LOG.debug("deleting cache file {}", (Object)this.file.getName());
                if (!this.file.delete()) {
                    AbstractContentCache.LOG.debug("could not delete cache file {}; deleting on exit", (Object)this.file.getName());
                    this.file.deleteOnExit();
                }
            }
        }
    }
}

