/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.concurrent;

import com.atlassian.util.concurrent.ExecutorSubmitter;
import com.atlassian.util.concurrent.LimitedExecutor;
import com.atlassian.util.concurrent.Promise;
import com.atlassian.util.concurrent.Promises;
import com.atlassian.util.concurrent.Supplier;
import com.atlassian.util.concurrent.Suppliers;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

public final class Executors {
    public static Executor limited(Executor delegate, int limit) {
        return new LimitedExecutor(delegate, limit);
    }

    public static ExecutorSubmitter submitter(Executor delegate) {
        return new DefaultSubmitter(delegate);
    }

    private Executors() {
        throw new AssertionError((Object)"cannot instantiate!");
    }

    static class DefaultSubmitter
    implements ExecutorSubmitter {
        private final Executor executor;

        DefaultSubmitter(Executor executor) {
            this.executor = executor;
        }

        @Override
        public void execute(Runnable command) {
            this.executor.execute(command);
        }

        @Override
        public <T> Promise<T> submit(Callable<T> callable) {
            CallableRunner<T> runner = new CallableRunner<T>(callable);
            this.executor.execute(runner);
            return runner.get();
        }

        @Override
        public <T> Promise<T> submit(Supplier<T> supplier) {
            return this.submit(Suppliers.toCallable(supplier));
        }

        static class CallableRunner<T>
        implements Runnable,
        Supplier<Promise<T>> {
            final Callable<T> task;
            final SettableFuture<T> future = SettableFuture.create();

            CallableRunner(Callable<T> task) {
                this.task = task;
            }

            @Override
            public void run() {
                try {
                    this.future.set(this.task.call());
                }
                catch (Exception ex) {
                    this.future.setException((Throwable)ex);
                }
            }

            @Override
            public Promise<T> get() {
                return Promises.forListenableFuture(this.future);
            }
        }
    }
}

