/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.concurrent;

import com.atlassian.util.concurrent.Awaitable;
import com.atlassian.util.concurrent.Supplier;
import com.atlassian.util.concurrent.TimedOutException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public final class Timeout {
    private final long created;
    private final long time;
    private final TimeSupplier supplier;

    public static Timeout getNanosTimeout(long time, TimeUnit unit) {
        return new Timeout(time, unit, TimeSuppliers.NANOS);
    }

    public static Timeout getMillisTimeout(long time, TimeUnit unit) {
        return new Timeout(time, unit, TimeSuppliers.MILLIS);
    }

    static Supplier<Timeout> timeoutFactory(final long time, final TimeUnit unit, final TimeSupplier supplier) {
        return new Supplier<Timeout>(){

            @Override
            public Timeout get() {
                return new Timeout(time, unit, supplier);
            }
        };
    }

    Timeout(long time, TimeUnit unit, TimeSupplier supplier) {
        this.created = supplier.currentTime();
        this.supplier = supplier;
        this.time = this.supplier.precision().convert(time, unit);
    }

    public long getTime() {
        return this.created + this.time - this.supplier.currentTime();
    }

    public TimeUnit getUnit() {
        return this.supplier.precision();
    }

    public boolean isExpired() {
        return this.getTime() <= 0L;
    }

    void await(Awaitable waitable) throws TimeoutException, InterruptedException {
        if (!waitable.await(this.getTime(), this.getUnit())) {
            this.throwTimeoutException();
        }
    }

    void await(Condition condition) throws TimeoutException, InterruptedException {
        if (!condition.await(this.getTime(), this.getUnit())) {
            this.throwTimeoutException();
        }
    }

    public void throwTimeoutException() throws TimedOutException {
        throw new TimedOutException(this.getTime(), this.getUnit());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TimeSuppliers implements TimeSupplier
    {
        NANOS{

            public long currentTime() {
                return System.nanoTime();
            }

            public TimeUnit precision() {
                return TimeUnit.NANOSECONDS;
            }
        }
        ,
        MILLIS{

            public long currentTime() {
                return System.currentTimeMillis();
            }

            public TimeUnit precision() {
                return TimeUnit.MILLISECONDS;
            }
        };

    }

    static interface TimeSupplier {
        public long currentTime();

        public TimeUnit precision();
    }
}

