/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.concurrent;

import com.atlassian.util.concurrent.Assertions;
import com.atlassian.util.concurrent.LimitedExecutor;
import com.atlassian.util.concurrent.NotNull;
import com.atlassian.util.concurrent.RuntimeInterruptedException;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class AsyncCompleter {
    private final Executor executor;
    private final Exceptions policy;

    AsyncCompleter(Executor executor, Exceptions policy) {
        this.executor = Assertions.notNull("executor", executor);
        this.policy = Assertions.notNull("plicy", policy);
    }

    public <T> Iterable<T> invokeAll(Iterable<? extends Callable<T>> callables) {
        ImmutableList lazyAsyncSuppliers = ImmutableList.copyOf((Iterable)Iterables.transform(callables, new AsyncCompletionFunction(this.executor)));
        Iterable handled = Iterables.transform((Iterable)lazyAsyncSuppliers, this.policy.handler());
        return Iterables.filter((Iterable)Iterables.transform((Iterable)handled, new ValueExtractor()), (Predicate)Predicates.notNull());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ExceptionIgnorer<T>
    implements Function<Supplier<T>, Supplier<T>> {
        ExceptionIgnorer() {
        }

        public Supplier<T> apply(Supplier<T> from) {
            return new ReturnNull<T>(from);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ReturnNull<T>
        implements Supplier<T> {
            private final Supplier<T> delegate;

            ReturnNull(Supplier<T> delegate) {
                this.delegate = Assertions.notNull("delegate", delegate);
            }

            public T get() {
                try {
                    return (T)this.delegate.get();
                }
                catch (RuntimeException ignore) {
                    return null;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ValueExtractor<T>
    implements Function<Supplier<T>, T> {
        private ValueExtractor() {
        }

        public T apply(Supplier<T> input) {
            return (T)input.get();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AsyncCompletionFunction<T>
    implements Function<Callable<T>, Supplier<T>> {
        private final CompletionService<T> completionService;
        private final Supplier<T> nextCompleteItem = new Supplier<T>(){

            public T get() {
                try {
                    return AsyncCompletionFunction.this.completionService.take().get();
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
                catch (InterruptedException e) {
                    throw new RuntimeInterruptedException(e);
                }
            }
        };

        AsyncCompletionFunction(Executor executor) {
            this.completionService = new ExecutorCompletionService<T>(executor);
        }

        public Supplier<T> apply(Callable<T> task) {
            this.completionService.submit(task);
            return Suppliers.memoize(this.nextCompleteItem);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Exceptions {
        IGNORE_EXCEPTIONS{

            @Override
            public <T> Function<Supplier<T>, Supplier<T>> handler() {
                return new ExceptionIgnorer();
            }
        }
        ,
        THROW{

            @Override
            public <T> Function<Supplier<T>, Supplier<T>> handler() {
                return Functions.identity();
            }
        };


        abstract <T> Function<Supplier<T>, Supplier<T>> handler();
    }

    public static class Builder {
        Executor executor;
        Exceptions policy = Exceptions.THROW;

        public Builder(@NotNull Executor executor) {
            this.executor = Assertions.notNull("executor", executor);
        }

        public Builder ignoreExceptions() {
            return this.handleExceptions(Exceptions.IGNORE_EXCEPTIONS);
        }

        public Builder handleExceptions(Exceptions policy) {
            this.policy = policy;
            return this;
        }

        public AsyncCompleter limitParallelExecutionTo(int limit) {
            return new AsyncCompleter(new LimitedExecutor(this.executor, limit), this.policy);
        }

        public AsyncCompleter build() {
            return new AsyncCompleter(this.executor, this.policy);
        }
    }
}

