/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.concurrent;

import java.util.concurrent.TimeUnit;
import net.jcip.annotations.Immutable;

@Immutable
public class Timeout {
    private static final TimeSupplier NANO_SUPPLIER = new TimeSupplier(){

        public long currentTime() {
            return System.nanoTime();
        }

        public TimeUnit precision() {
            return TimeUnit.NANOSECONDS;
        }
    };
    private static final TimeSupplier MILLIS_SUPPLIER = new TimeSupplier(){

        public long currentTime() {
            return System.currentTimeMillis();
        }

        public TimeUnit precision() {
            return TimeUnit.MILLISECONDS;
        }
    };
    private final long created;
    private final long time;
    private final TimeSupplier supplier;

    public static Timeout getNanosTimeout(long time, TimeUnit unit) {
        return new Timeout(time, unit, NANO_SUPPLIER);
    }

    public static Timeout getMillisTimeout(long time, TimeUnit unit) {
        return new Timeout(time, unit, MILLIS_SUPPLIER);
    }

    Timeout(long time, TimeUnit unit, TimeSupplier supplier) {
        this.created = supplier.currentTime();
        this.supplier = supplier;
        this.time = this.supplier.precision().convert(time, unit);
    }

    public long getTime() {
        return this.created + this.time - this.supplier.currentTime();
    }

    public TimeUnit getUnit() {
        return this.supplier.precision();
    }

    public boolean isExpired() {
        return this.getTime() <= 0L;
    }

    static interface TimeSupplier {
        public long currentTime();

        public TimeUnit precision();
    }
}

