/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.memory;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.impl.DefaultGroup;
import com.atlassian.user.impl.DuplicateEntityException;
import com.atlassian.user.impl.memory.provider.MemoryProvider;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.PagerUtils;
import com.atlassian.user.util.Assert;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryGroupManager
implements GroupManager {
    private final MemoryProvider provider;
    private final RepositoryIdentifier repository;

    public MemoryGroupManager(RepositoryIdentifier repository, MemoryProvider provider) {
        this.provider = provider;
        this.repository = repository;
    }

    @Override
    public Group createGroup(String groupName) throws EntityException {
        if (this.getGroup(groupName) != null) {
            throw new DuplicateEntityException("The group [" + groupName + "] already exists.");
        }
        DefaultGroup group = new DefaultGroup(groupName);
        this.provider.addGroup(group);
        return group;
    }

    @Override
    public void removeGroup(Group group) throws EntityException {
        this.provider.removeGroup(group);
    }

    @Override
    public void addMembership(Group group, User user) {
        if (group == null) {
            throw new IllegalArgumentException("Can't add membership for null group");
        }
        if (this.getGroup(group.getName()) == null) {
            throw new IllegalArgumentException("Can't add membership for unknown group: [" + group.getName() + "]");
        }
        this.provider.addMembership(group, user);
    }

    @Override
    public boolean hasMembership(Group group, User user) {
        return this.provider.hasMembership(group, user);
    }

    @Override
    public Pager<Group> getGroups() {
        return this.provider.getGroups();
    }

    @Override
    public Group getGroup(String groupName) {
        return this.provider.getGroup(groupName);
    }

    @Override
    public Pager<Group> getGroups(User user) throws EntityException {
        Assert.notNull(user, "User must not be null");
        return this.provider.getGroups(user);
    }

    @Override
    public List<Group> getWritableGroups() {
        return PagerUtils.toList(this.getGroups());
    }

    public RepositoryIdentifier getConfiguration() {
        return this.repository;
    }

    @Override
    public RepositoryIdentifier getIdentifier() {
        return this.repository;
    }

    @Override
    public RepositoryIdentifier getRepository(Entity entity) throws EntityException {
        if (this.getGroup(entity.getName()) != null) {
            return this.repository;
        }
        return null;
    }

    public String getApplicationKey() {
        return null;
    }

    @Override
    public boolean isCreative() {
        return true;
    }

    @Override
    public void removeMembership(Group group, User user) {
        if (group == null || this.getGroup(group.getName()) == null) {
            throw new IllegalArgumentException("Can't remove membership for unknown group: [" + (group == null ? "null" : group.getName()) + "]");
        }
        this.provider.removeMembership(group, user);
    }

    @Override
    public Pager<String> getMemberNames(Group group) {
        return this.provider.getMemberNames(group);
    }

    @Override
    public Pager<String> getLocalMemberNames(Group group) throws EntityException {
        return this.provider.getLocalMemberNames(group);
    }

    @Override
    public Pager<String> getExternalMemberNames(Group group) throws EntityException {
        return this.provider.getExternalMemberNames(group);
    }

    @Override
    public boolean isReadOnly(Group group) throws EntityException {
        return false;
    }

    @Override
    public boolean supportsExternalMembership() throws EntityException {
        return true;
    }
}

