package com.atlassian.user.security.password;

import java.util.HashMap;

public interface PasswordEncryptor
{
    /**
     * @return an encrypted version of the original {@link String} unencryptedPassword
     */
    String encrypt(String unencryptedPassword);

    /**
     * @deprecated since 13 March 2007, use constructor instead.
     */
    void init(HashMap args);

    /**
     * If the credential is unencrypted, encrypts its value and returns it. Otherwise returns the
     * already-encrypted value held by the credential.
     *
     * @param credential the credential whose encrypted value will be returned
     * @return the encrypted credential value
     * @since 2.2
     */
    String getEncryptedValue(Credential credential);
}
