package com.atlassian.user.search.query;

import java.util.List;
import java.util.Arrays;

public class MultiTermBooleanQuery extends AbstractBooleanQuery
{
    private Query[] collatedQueries;

    public MultiTermBooleanQuery(Query[] collatedQueries, boolean anding)
    {
        super(anding);
        this.collatedQueries = collatedQueries;
    }

    public List<Query> getQueries()
    {
        return Arrays.asList(collatedQueries);
    }

    /**
     * Returns a multi-term boolean query which joins the provided queries using AND.
     *
     * @param queries the components of the boolean query
     * @since 2.1
     */
    public static Query allOf(Query... queries)
    {
        return new MultiTermBooleanQuery(queries, true);
    }

    /**
     * Returns a multi-term boolean query which joins the provided queries using OR.
     *
     * @param queries the components of the boolean query
     * @since 2.1
     */
    public static Query anyOf(Query... queries)
    {
        return new MultiTermBooleanQuery(queries, false);
    }
}
