package com.atlassian.user.search.page;

import java.util.*;

public class DefaultPager<T> implements Pager<T>
{
    private final List<T> page = new ArrayList<T>();
    private Iterator<T> iter;
    private int index;

    public static <T> DefaultPager<T> emptyPager()
    {
        return new DefaultPager<T>(Collections.<T>emptyList());
    }

    /** @deprecated since 2.0.3. Use the generic-friendly emptyPager() method */
    public DefaultPager()
    {
        this(Collections.<T>emptyList());
    }

    public DefaultPager(Collection<T> col)
    {
        if (col != null)
        {
            page.addAll(col);
        }

        iter = page.iterator();
    }

    public boolean isEmpty()
    {
        if (page == null) return true;

        return page.isEmpty();
    }

    public Iterator<T> iterator()
    {
        return iter;
    }

    /**
     * @return a single, preloaded page.
     */
    public List<T> getCurrentPage()
    {
        return new ArrayList<T>(page);
    }

    public void nextPage()
    {
        //do nothing, all contents are already within the currentPage
    }

    public boolean onLastPage()
    {
        return true;
    }

    public void skipTo(int index) throws PagerException
    {
        if (index < 0)
            throw new PagerException("Cannot skipTo a negative amount [" + index + "]");

        int originalIndex = this.index;
        int distance;

        if (index > page.size())
        {
            distance = page.size();
            this.index = page.size();
        }
        else
        {
            distance = index - this.index;
            this.index = index;
        }

        for (int i = originalIndex; i < distance; i++)
            iter.next();
    }

    /**
     * @return the current index position of the pager
     */
    public int getIndex()
    {
        return index;
    }

    /**
     *  This pager always has all its items in a single page
     * @return zero, because this pager has all its items in a single page
     */
    public int getIndexOfFirstItemInCurrentPage()
    {
        return 0;
    }

    public void remove()
    {
        throw new UnsupportedOperationException("This iterator does not support removal");
    }

    public boolean hasNext()
    {
        return iter.hasNext();
    }

    public T next()
    {
        T o = iter.next();
        index++;

        return o;
    }
}
