package com.atlassian.user.impl.osuser.security.authentication;

import com.atlassian.user.EntityException;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.security.authentication.Authenticator;
import com.opensymphony.user.provider.CredentialsProvider;

import java.util.Iterator;
import java.util.List;

/**
 * Authenticates against the first provider that handles the username.
 * If authentication fails, it will <b>not</b> fall back or try another provider
 */
public class OSUListOfCredentialProvidersAuthenticator implements Authenticator
{
    private final RepositoryIdentifier repository;
    private final List credentialProviders;

    public OSUListOfCredentialProvidersAuthenticator(RepositoryIdentifier repository, List credentialProviders)
    {
        this.repository = repository;
        this.credentialProviders = credentialProviders;
    }

    public boolean authenticate(String username, String password) throws EntityException
    {
        Iterator iter = credentialProviders.iterator();
        while (iter.hasNext())
        {
            CredentialsProvider provider = (CredentialsProvider) iter.next();
            if (provider.handles(username))
                return provider.authenticate(username, password);
        }

        return false;
    }

    public RepositoryIdentifier getRepository()
    {
        return repository;
    }
}
