package com.atlassian.user.impl.memory;

import com.atlassian.user.*;
import com.atlassian.user.impl.ReadOnlyGroupManager;
import com.atlassian.user.impl.memory.provider.MemoryProvider;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.page.Pager;

/**
 * @deprecated since 2.2 because it should not be used in production. Will be moved to test code in 3.0.
 */
public class MemoryGroupManagerReadOnly extends ReadOnlyGroupManager
{
    private final RepositoryIdentifier repository;
    private final MemoryProvider provider;

    public MemoryGroupManagerReadOnly(RepositoryIdentifier config, MemoryProvider provider)
    {
        this.repository = config;
        this.provider = provider;
    }

    public Pager<Group> getGroups()
    {
        return provider.getGroups();
    }

    public boolean hasMembership(com.atlassian.user.Group group, com.atlassian.user.User user)
    {
        return provider.hasMembership(group, user);
    }

    public boolean supportsExternalMembership() throws EntityException
    {
        return false;
    }

    public com.atlassian.user.Group getGroup(String groupName)
    {
        return provider.getGroup(groupName);
    }

    public Pager<Group> getGroups(User user)
    {
        return provider.getGroups(user);
    }

    public void setUserManager(UserManager userManager)
    {
        //To change body of implemented methods use File | Settings | File Templates.
    }

    public Pager<String> getMemberNames(com.atlassian.user.Group group)
    {
        return provider.getMemberNames(group);
    }

    public Pager<String> getLocalMemberNames(Group group) throws EntityException
    {
        return provider.getLocalMemberNames(group);
    }

    public Pager<String> getExternalMemberNames(Group group) throws EntityException
    {
        throw new UnsupportedOperationException("External membership is not supported");
    }

    /**
     * @return the {@link com.atlassian.user.repository.RepositoryIdentifier} which is managed by this instance.
     */
    public RepositoryIdentifier getIdentifier()
    {
        return repository;
    }

    public RepositoryIdentifier getRepository(Entity entity) throws EntityException
    {
        if (getGroup(entity.getName()) != null)
            return repository;
        else
            return null;
    }
}
