package com.atlassian.user.impl.ldap.search.page;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.impl.ldap.LDAPEntityFactory;
import com.atlassian.user.impl.ldap.properties.LdapSearchProperties;
import com.atlassian.user.impl.ldap.repository.LdapContextFactory;
import com.atlassian.user.impl.ldap.search.LDAPPagerInfo;
import org.apache.log4j.Category;

import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import java.util.List;

public class LDAPEntityPager<T extends Entity> extends AbstractLDAPPager<T>
{
    public static final Category log = Category.getInstance(LDAPEntityPager.class);
    protected LDAPEntityFactory<? extends T> entityFactory;

    public LDAPEntityPager(LdapSearchProperties searchProperties,
                           LdapContextFactory repository, LDAPEntityFactory<? extends T> entityFactory, LDAPPagerInfo info)
    {
        super(searchProperties, repository, info);
        this.entityFactory = entityFactory;

        preload();
    }

    protected List<T> preloadSearchResult(SearchResult result, List<T> prefetched) throws EntityException
    {
        try
        {
            Attributes entityAttributes = result.getAttributes();
            T entity = entityFactory.getEntity(entityAttributes, result.getName());
            prefetched.add(entity);
        }
        catch (Throwable e)
        {
            log.error("There was an error converting the SearchResult: " + result + " into an entity or entities.", e);
        }

        return prefetched;
    }
}
