package com.atlassian.user.impl.cache;

import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.Entity;
import com.atlassian.cache.CacheFactory;

/**
 * The repository cache is a cache where the key is the entity name as a
 * {@link String} and the value is the {@link com.atlassian.user.repository.RepositoryIdentifier} which
 * contains the entity.
 * <p/>
 * This shouldn't be necessary once {@link com.atlassian.user.Entity} objects are aware
 * of the repository which manages them.
 * <p/>
 * A separate cache for {@link com.atlassian.user.User} and {@link com.atlassian.user.Group}
 * objects should be maintained, since they have a separate namespace for names.
 */
public class EntityRepositoryCache
{
    private final CacheFactory cacheFactory;
    private final String cacheName;

    public EntityRepositoryCache(CacheFactory cacheFactory, String cacheName)
    {
        this.cacheFactory = cacheFactory;
        this.cacheName = cacheName;
    }

    private com.atlassian.cache.Cache getCache()
    {
        return cacheFactory.getCache(cacheName);
    }

    public void put(Entity entity, RepositoryIdentifier repository)
    {
        getCache().put(entity.getName(), repository);
    }

    /**
     * Returns the repository containing the entity if found in the case,
     * or null if this entity is not in the cache.
     */
    public RepositoryIdentifier get(Entity entity)
    {
        return (RepositoryIdentifier) getCache().get(entity.getName());
    }

    public void remove(Entity entity)
    {
        getCache().remove(entity.getName());
    }
}
