package com.atlassian.user.configuration;

import com.atlassian.user.security.authentication.Authenticator;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.UserManager;
import com.atlassian.user.GroupManager;
import com.atlassian.user.search.query.EntityQueryParser;
import com.atlassian.user.properties.PropertySetFactory;

/**
 * Represents all components configured upon a repository.
 * <p/>
 * An entire delegation would be composed of one {@link DelegationAccessor}
 */
public interface RepositoryAccessor
{
    RepositoryIdentifier getIdentifier();

    UserManager getUserManager();

    GroupManager getGroupManager();

    PropertySetFactory getPropertySetFactory();

    Authenticator getAuthenticator();

    EntityQueryParser getEntityQueryParser();
}
