/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.test;

import com.atlassian.upm.api.util.Option;
import java.util.Iterator;

public interface TestUser {
    public static final TestUser SYSADMIN = new TestUserImpl("admin", "admin");
    public static final TestUser REGULAR_ADMIN = new TestUserImpl("betty", "betty");
    public static final TestUser OTHER_REGULAR_ADMIN = new TestUserImpl("fred", "fred");
    public static final TestUser NON_ADMIN = new TestUserImpl("barney", "barney");
    public static final TestUser ANONYMOUS = new TestUserImpl();

    public Option<Credentials> getCredentials();

    public boolean isAdmin();

    public static class TestUserImpl
    implements TestUser {
        private final Option<Credentials> credentials;

        TestUserImpl(String username, String password) {
            this.credentials = Option.some((Object)new Credentials(username, password));
        }

        TestUserImpl() {
            this.credentials = Option.none();
        }

        @Override
        public Option<Credentials> getCredentials() {
            return this.credentials;
        }

        @Override
        public boolean isAdmin() {
            return this == SYSADMIN || this == REGULAR_ADMIN || this == OTHER_REGULAR_ADMIN;
        }

        public String toString() {
            Iterator iterator = this.credentials.iterator();
            if (iterator.hasNext()) {
                Credentials c = (Credentials)iterator.next();
                return c.username;
            }
            return "[anonymous]";
        }

        public boolean equals(Object other) {
            if (other instanceof TestUser) {
                return ((TestUser)other).getCredentials().equals(this.credentials);
            }
            return false;
        }

        public int hashCode() {
            return this.credentials.hashCode();
        }
    }

    public static class Credentials {
        public final String username;
        public final String password;

        public Credentials(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public boolean equals(Object other) {
            if (other instanceof Credentials) {
                Credentials c = (Credentials)other;
                return c.username.equals(this.username) && c.password.equals(this.password);
            }
            return false;
        }

        public int hashCode() {
            return this.username.hashCode() * 37 + this.password.hashCode();
        }
    }
}

