/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.test;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.upm.api.util.Option;
import com.google.common.collect.ImmutableList;
import java.net.URI;

public class TestApplication {
    public static final URI FAKE_APP_DOWNLOAD_PAGE = URI.create("http://www.atlassian.com/fake/app/download");
    private static final String OBR_DOWNLOAD_PATH = "/rest/fakempac/1.0/products/";
    public static final TestApplication JIRA_CORE = TestApplication.builder().key("jira-core").platform(true).name("Jira Core").evalTimebombLicense("AAABIw0ODAoPeNp1UMtuwjAQvPsrLPVslFA4gORLiSmoNEQk0IqbMQt1m9jW2knh7xselVqqHvYwo\n5nZ0dyNUdMxbGg3onFv2BsM43ua5UWL4z5JwCvULmhreAE+0FIrMB7oziJ1Zb3Xhm6hgdI6QE/Su\ntoAzndL3yLOYjJCkCdzIgPwUyKLuqwbkXeNsjO7ZImtPueLtBCLbDHNBRGNLOuzkQes4SKXKugGf\nhAO7bZWoXMCTFmEX5JnqU0AI40CcXAaj+cOWTwhc9xLo/0lXxxk5UqgI1s5aY4kB2wApwl/eBwU7\nHW56rGn9XrCHqL4heQi5e2xfhSRa/tWuTQfxn6ab+bm2z9V/0x1dRdHB6msgCdiJWbzTCxIVqN6k\nx5uR/wCsReV3TAsAhQnReAwgN/aQ0ra/J5bfUxDXXOSLQIUeebNT0D/4XBHG61DjBB3oJcNKR0=X\n02em").nonEvalTimebombLicense("AAABLA0ODAoPeNp1UMlOwzAUvPsrLHF2lRSiApIvbSxaKGnUpAX1ZpzXYnBsy0to/55uSCzi8A7zN\nJvmoo6A77nG/QFO09v0+jbLcFnVuJ+kGcrBCydtkEbTGnzASgrQHvDaOGxV3EiNG+hAGQvOoyK2L\n+Bm64XfI5omaOSAH8Q5D0APjiRJSX+A3qTjvenJizXy6M+Kms3L+aRiiHVcxaOQrrnycOJzEWQHN\nLh4flhnmihC7wCIMA5+UB651AE01wLY1kq3O5YoL8do5jZcS38KYFveWgV4ZFrL9Q5V4Dpwk5wO7\n25q8rxYXpGH1WpMhkn6hCpW0P2RLEnQuf6eudDv2nzor8+3tKiVbGWA5r/CfxY7e9Q7CwVvgeZsy\naazks1RGZ145R5+b/kJazqZXTAsAhQaRf4Cssg6Pk1SmDcR9yGC6wE1hgIUa4QqCAIYuxHGJF0LE\n3iHxnOydFM=X02f3").communityRenewalTimebombLicense("AAABLQ0ODAoPeNp1UFtPwjAUfu+vaOLzyIYuRpK+AFWIMha2gfJWugNWt645bSf8e8fFxEtMznn4T\nr5bztUKSnoPGxpF3QzCeBDf0jTLaT+MYjIGK1EZpxrNcrCOVkqCtkC3DVJT+Z3StIQWqsYAWpL4e\ngM43xa2QywKyQhBHMVj4YAdHYOwH0QReVMoek9nL16qkz9Pcr5IF9OME96Kyp+EbCsqC2e+kE61w\nBz6y8FgU3rpekcQyAbhB2UmlHaghZbA90bh4VQivZ6QOe6EVvYcwPeiNhXQUVMboQ8kA2wBp2M2f\nLjLg+dieRM8rteTYBhGK5LxhHUbxGGfXOp3zEK/6+ZDf12+pXldqVo5KP8r/OdjF4/8YCARNbDRf\nDYrkmn+QlKP8lVY+P3LTysymU8wLAIUHRN4Cnpf8mz4TF/0GP0loru/MwUCFHfAFu7aPftB1lkzC\nANBr/uct8QTX02f3").communityUpgradeTimebombLicense("AAABLw0ODAoPeNp1UN1PwjAQf+9f0cTnkm0BP0j6AlQhyljcJspb6Q6sdm3TdhP+e8eHiZKY3D3c5\nfd1d7WECt/DGsdxV8OoP0z6OMsLnETxAE3ACydtkEbTAnzASgrQHvDGOGxVs5UaV9CCMhacR2lTr\n8EtNqXvJjpAYwf8wJ3wAPQgSKKExDH6kI73nk5SrJJHeZYW7Dl7nuUMsZar5kikG648nPBcBNkCD\na45L6wzVSNC7zAQYRz8gcy51AE01wLYzkq3P4bIbm+uoylauC3X0p882I7XVgEem9pyvUc5uBbcb\nEJHD3cFeS1f+uRxtZqSURQvUc5S2jUZRAk6X9AhS/2pzZf+2fwybLSStQxQ/Zf58mdniWJvIeU10\nPFiPi/TWfGGssaJd+7h8pvfrqaZkjAsAhQ/D9X/LJNmdngA67HoUIGUx73BxwIUJ+Gt0xvC2JRlc\nm7ygZ7aCiOPcIc=X02f7").build();
    public static final TestApplication JIRA_SOFTWARE = TestApplication.builder().key("jira-software").name("Jira Software").availableVersion((Option<String>)Option.some((Object)"99.0")).evalTimebombLicense("AAABJQ0ODAoPeNptUMtuwjAQvPsrLPVslKRwKJIvEFNQaYhIoBU3ExbqNrGttRPg7xteUgU97GFGM\n7Oz+zRCRUewplFAw14/6vafQ5pmeYvDHonBFaisV0bzHJynpSpAO6Bbg9SW9U5puoEGSmMBHUnqa\ng042y5cizgLyRBBnsyx9MBPiSyIWBSQb4WyM71kiY0654skF/N0PskEEY0s67ORe6zhIrdoNnXhO\nyfAnNn6vUToyMKrBv7IHoj/fQ9V36XSHrTUBYiDVXg8d07DMZnhTmrlLn3EQVa2BDo0lZX6SDLAB\nnAS88HrS84+F8sue1utxmwQhB8kEwlvh/WCgFyvbZUL/aPNXt+Yu21XNj9aSGQFPBZLMZ2lYk7SG\nosv6eD+mb+sP5lbMCwCFC37pQlCzOa5ud9PAIt75fIkljgHAhRQzTx/+fgm5PmeoNtaYaT/6m4tv\nw==X02eq").nonEvalTimebombLicense("AAABLw0ODAoPeNptUMtuwjAQvPsrLPUc5JQitUi+QKyCCiGCQCtubrKhbh3HWtsB/r7hJVVtD3vY2\nZnZ2b3LA9C5RBozGsfDweOQxTRLcnrP4gFJwBWorFeN4Tk4T7UqwDigVYPU6rBThpbQgm4soCNpq\nN8BF9XadR2PGRkjyJM4kR74yTFi/ajDPxXK3uziJUp19hdpLpbZcroSRLRSh7OQV1I7uPAtNmUof\nO/URK6p/F4i9GThVQvcY7jS/gD/6/5knUtlPBhpChAHq/B4Dp31J2SBO2mUuwQSB1lbDXTc1FaaI\n1kBtoDThI+en/Lobb15iF6220k0YvErWYmUdxUNGCPXczvm2nyZZm9uyI9twWhVKw/lbZYfLaSyB\np6IjZgtMrEkWcDiQzr4/dNvPZecwDAtAhQ/oebCxJd/NCt0R4KonwvK7jNK6QIVAJbhOXBkjRY6E\n1vSHC8PdcewkUZwX02f7").communityRenewalTimebombLicense("AAABMg0ODAoPeNptUE1vwjAMvedXRNo5qIGhaUi5ANlAG6Wi7di4hdZl2dokStIC/34tH9I0JtkH2\n+89P/tuDTl+gi2mtI1RMBwNHnAUJ7gf0CGagsusNF5qxRJwHpcyA+UAF9piU9Y7qXAODZTagHUor\nKst2GWRurZiNEATC6IjT4UH1imSoE8oRV/Sit7rWYvn8qTPw4SvotU85og3oqxPRFaI0sEZb6zO6\n8z3uoI4Xfi9sNATmZcNMG/rC+ym8T/vxutCSOVBCZUBPxhpjyfT0WCGlnYnlHRnQ/wgKlMCnujKC\nHVEMdgG7HzKxs+PCXlP3+7Jy2YzI+OArlHMQ9YmGQYUXc5tkan6Vnqvrp1f22pVykp6yK+z5GggF\nBWwyXKxSMN58oGi2mafwsHfn/4AI+Wc0DAsAhRQ75DbMqkaU7MMnA/kiPs92P1MUgIUCdi9Omznr\nJB0zF9DCJ4A+uG+WAk=X02fb").communityUpgradeTimebombLicense("AAABNA0ODAoPeNptUE1vwjAMvedXRNo5qGUr25ByAbKBNkpF27FxC63LsqVplKQF/v1aPqSJTbIPt\nt97fvbNCnL8BBvs+20MvdthMMBRnOC+5wdoAjYzQjtRKZqAdViKDJQFXFQGa1lvhcI5NCArDcais\nC43YBZFatuKBmhsgHfcCXdAO0Hi9Ynvoy9heO/1JMVycZRnYcKW0XIWM8QaLusjkRZcWjjhtanyO\nnO9riC2KtyOG+jxzIkGqDP1Gfan8T/v2uqcC+VAcZUB22thDkfP0cP9wJuihdlyJezJEtvzUkvA4\n6rUXB1QDKYBM5vQ0fNjQt7Ttzvysl5PycjzVyhmIW2TBJ6Pzge3yFR9q2qnLp1fC2slRSkc5JdZc\ntAQ8hLoeDGfp+Es+UBRbbJPbuH6qz/iDJ0ZMCwCFEQ/9b5HozDGy2dp95+d2KRkwRfQAhQeSTz9t\nwGf+KgzXz1FM8krDU2O2g==X02ff").build();
    public static final TestApplication FAKE_APPLICATION = TestApplication.builder().key("fake-app").availableVersion((Option<String>)Option.some((Object)"1.0.1")).name("Fake Application").titleLogoFileName("fake-app-logo.png").primaryPluginKey("com.atlassian.test.fake-app-primary-plugin").applicationPluginKeys("com.atlassian.test.fake-app-plugin-1").utilityPluginKeys("com.atlassian.test.fake-app-plugin-util").evalTimebombLicense("AAABKw0ODAoPeNp1kEFvwjAMhe/5FZF2DkopHIaUCzQbbKxUtLCJm9caltGmUZp08O8HdEho0w4+2\nH7v07PvHqyiT6BpyGkQjvrBaDCkSZrRPg+GJMImt8o4VWuRYeNoqXLUDdJtbakp/U5pWmCLZW3QN\niT21TvaxXbVnDrBAjKxCGdzBA7Fmch4wEJOPpWF3rxjyUJd+DLO5DJZzlJJZAulvxiFsx47ubF14\nXPX28IeGRjTg9ypFm8Ut4MXUNqhBp2jPBhlj5cISTj9B/Yn+sLuQKumSyEPUJkS6aSuDOgjSdG2a\nGeRGD/eZ+xttR6w581mysY8eCWpjMWp2JBz8nPjSbnSe11/6evkJpTXpaqUw+K6y44GY6hQRHIt5\n4tELknibf4BDf5+5DepPpf6MCwCFDvfShFtEv+IcKaj8SM9zdo+2mDRAhR+VWWWS8c3KaD4bgsb6\nq8ns5FiWw==X02f3").nonEvalTimebombLicense("AAABMA0ODAoPeNp1kMtuwjAQRff+CktdByU8KorkDcQqtDREJEDFbppMqEviWH6k8PcNLwm16mIWM\n3Pv0Z152GBOX0DS7pAGvVH/cRT4NE5S2vWDAQnRZFooK2rJUjSWliJDaZAWtaaqdDshaY4NlrVCb\nUjkqg/Ui2Jl2o4FPplohJM5BIvsRPT8wOsOyZfQ0JlfWDwXZz6PUr6Ml7OEE95A6c5GVkBp8KJXu\ns5dZjsF7NEDpTqQWdEgs9pdFfeDNxDSogSZIT8ooY/nDHFv+g/sT/aF3oEU5hKDH6BSJdJJXSmQR\n5KgblDPQjZ+fkq999W6771ut1Nv7AcbkvCIteUNfJ9cj2yVK7mX9be8Te5COVmKSljMb7v0qDCCC\nlnI13y+iPmSxE5nn2Dw9yd/AEo2mF4wLAIUUSoALz475A+xJ2rQCskd4zovQjcCFACns7R4WK3W+\n4Bk6Kldt57GIjKiX02f7").communityRenewalTimebombLicense("AAABLw0ODAoPeNp1UMFuwjAMvecrIu1c1MCQNqRcgGygjVLRdmzcTOuyjDaNkrSDv1+hIKFNk+yDn\n997evbdGjP6hFvKWFsjfzhiDzSMYtr32ZBM0aZGaicrxWO0jhYyRWWR5pWhuqh3UtEMGywqjcaSo\nC63aJZ5YtuJM59MDMJJPAWH/OTo+X2PMfIlDfReOy+RybO/CGKxClfzSBDRQFGfhTyHwmLH16bK6\ntT1ctijB1r3IHWyQe5MfWHcAguQyqEClaI4aGmO5wzhYPaP2Z/sS7MDJW0XQxyg1AXSSVVqUEcSo\nWnQzKd8/PwYe+/J2733stnMvLHP1iQSAW/bG/oDcjmyZSZqr6pvdUVuQtWqkKV0mF138VFjACXyy\nXKxSIJ5/EHC2qSfYPH3J38AJOOYXzAsAhR/QCfBZuL7al0jEoACU7uVJjWX/QIUB02HIGV7sPaMg\nMmCshKYquwFyZ0=X02f7").communityUpgradeTimebombLicense("AAABMQ0ODAoPeNp1UMtuwjAQvPsrLPUclFBCWyRfALeglhCRpLTclmRDXRLHsp0U/p7wkhBSpd3Dz\ns6MZvdhiRl9xTX1vLYGbm/g92kYxbTrej4Zo0m1UFZUksVoLC1EitIgzStNVVFvhKQZNlhUCrUhQ\nV2uUc/zxLQT88lIIxy1Y7DIjoaO23U8j/wKDZ2PsxXPxMmeBzFfhItpxAlvoKhPQpZDYfDMV7rK6\ntR2ctiiA0p1ILWiQWZ1fWHcAjMQ0qIEmSLfKaH3pwzh81Pfnfzjd59+rjcghTkH4TsoVYF0VJUK5\nJ5EqBvU0zEbvr3Ezlfy2XPeV6uJM3S9JYl4wNp2fPeRXM5smYncyupPXpGbWLUsRCksZtddvFcYQ\nIlsNJ/NkmAaf5Ow1ukPGLz/5QHIspiqMCwCFDuCp9qE+HWoqtcyp9B/HDs8uOWZAhQvMPnmCslf2\nOVxM+6r2U5rA/S7LQ==X02fb").build();
    public static final TestApplication INVALID_APPLICATION = TestApplication.builder().key("invalid-application").name("Invalid Application").build();
    private final boolean platform;
    private final String key;
    private final String name;
    private final Option<String> availableVersion;
    private final String evalTimebombLicense;
    private final String nonEvalTimebombLicense;
    private final String communityUpgradeTimebombLicense;
    private final String communityRenewalTimebombLicense;
    private final Option<String> titleLogoFileName;
    private final Option<String> primaryPluginKey;
    private final Iterable<String> applicationPluginKeys;
    private final Iterable<String> utilityPluginKeys;

    public static TestApplication[] nonPlatformApps() {
        return new TestApplication[]{JIRA_SOFTWARE, FAKE_APPLICATION, INVALID_APPLICATION};
    }

    public boolean isPlatform() {
        return this.platform;
    }

    public ApplicationKey getKey() {
        return ApplicationKey.valueOf((String)this.key);
    }

    public String getKeyValue() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public Option<String> getAvailableVersion() {
        return this.availableVersion;
    }

    public String getEvalTimebombLicense() {
        return this.evalTimebombLicense;
    }

    public String getNonEvalTimebombLicense() {
        return this.nonEvalTimebombLicense;
    }

    public String getCommunityUpgradeTimebombLicense() {
        return this.communityUpgradeTimebombLicense;
    }

    public String getCommunityRenewalTimebombLicense() {
        return this.communityRenewalTimebombLicense;
    }

    public String getDescription() {
        return "This is the description of " + this.name + ".";
    }

    public URI getLearnMoreUri() {
        return URI.create("http://atlassian.com/fake-product-page/" + this.key);
    }

    public Option<String> getTitleLogoFileName() {
        return this.titleLogoFileName;
    }

    public Iterable<String> getUninstallablePluginKeys() {
        return ImmutableList.builder().addAll(this.getPrimaryPluginKey()).addAll(this.getApplicationPluginKeys()).build();
    }

    public Option<String> getPrimaryPluginKey() {
        return this.primaryPluginKey;
    }

    public Iterable<String> getApplicationPluginKeys() {
        return this.applicationPluginKeys;
    }

    public Iterable<String> getUtilityPluginKeys() {
        return this.utilityPluginKeys;
    }

    public URI getDownloadUri(URI baseUri, String version) {
        return URI.create(baseUri.toASCIIString() + OBR_DOWNLOAD_PATH + this.getKeyValue() + "/" + version).normalize();
    }

    private TestApplication(Builder builder) {
        this.platform = builder.platform;
        this.key = builder.key;
        this.name = builder.name;
        this.availableVersion = builder.availableVersion;
        this.evalTimebombLicense = builder.evalTimebombLicense;
        this.nonEvalTimebombLicense = builder.nonEvalTimebombLicense;
        this.communityUpgradeTimebombLicense = builder.communityUpgradeTimebombLicense;
        this.communityRenewalTimebombLicense = builder.communityRenewalTimebombLicense;
        this.titleLogoFileName = builder.titleLogoFileName;
        this.primaryPluginKey = builder.primaryPluginKey;
        this.applicationPluginKeys = builder.applicationPluginKeys;
        this.utilityPluginKeys = builder.utilityPluginKeys;
    }

    private static Builder builder() {
        return new Builder();
    }

    private static class Builder {
        private boolean platform = false;
        private String key;
        private String name;
        private Option<String> availableVersion = Option.none();
        private String evalTimebombLicense;
        private String nonEvalTimebombLicense;
        private String communityUpgradeTimebombLicense;
        private String communityRenewalTimebombLicense;
        private Option<String> titleLogoFileName = Option.none();
        private Option<String> primaryPluginKey = Option.none();
        private Iterable<String> applicationPluginKeys = ImmutableList.of();
        private Iterable<String> utilityPluginKeys = ImmutableList.of();

        private Builder() {
        }

        Builder platform(boolean platform) {
            this.platform = platform;
            return this;
        }

        Builder key(String key) {
            this.key = key;
            return this;
        }

        Builder name(String name) {
            this.name = name;
            return this;
        }

        Builder availableVersion(Option<String> availableVersion) {
            this.availableVersion = availableVersion;
            return this;
        }

        Builder evalTimebombLicense(String lic) {
            this.evalTimebombLicense = lic;
            return this;
        }

        Builder nonEvalTimebombLicense(String lic) {
            this.nonEvalTimebombLicense = lic;
            return this;
        }

        Builder communityUpgradeTimebombLicense(String lic) {
            this.communityUpgradeTimebombLicense = lic;
            return this;
        }

        Builder communityRenewalTimebombLicense(String lic) {
            this.communityRenewalTimebombLicense = lic;
            return this;
        }

        Builder titleLogoFileName(String name) {
            this.titleLogoFileName = Option.some((Object)name);
            return this;
        }

        Builder primaryPluginKey(String key) {
            this.primaryPluginKey = Option.some((Object)key);
            return this;
        }

        Builder applicationPluginKeys(String ... keys) {
            this.applicationPluginKeys = ImmutableList.copyOf((Object[])keys);
            return this;
        }

        Builder utilityPluginKeys(String ... keys) {
            this.utilityPluginKeys = ImmutableList.copyOf((Object[])keys);
            return this;
        }

        TestApplication build() {
            return new TestApplication(this);
        }
    }
}

