/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.test.concurrent;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.joda.time.Duration;

public class NonExecutingScheduledExecutorService
implements ScheduledExecutorService {
    private final CopyOnWriteArrayList<TaskInfo> tasks = new CopyOnWriteArrayList();

    public List<TaskInfo> getQueuedTasks() {
        return this.tasks;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return true;
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public List<Runnable> shutdownNow() {
        return ImmutableList.of();
    }

    @Override
    public Future<?> submit(Runnable task) {
        this.schedule(task, 0L, TimeUnit.MILLISECONDS);
        return new FutureTask<Object>(task, null);
    }

    @Override
    public void execute(Runnable task) {
        task.run();
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        throw new IllegalStateException();
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw new IllegalStateException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new IllegalStateException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new IllegalStateException();
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        throw new IllegalStateException();
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        throw new IllegalStateException();
    }

    @Override
    public ScheduledFuture<?> schedule(final Runnable command, long delay, TimeUnit unit) {
        this.tasks.add(new TaskInfo(command, new Duration(unit.toMillis(delay))));
        return new ScheduledFuture<Void>(){

            @Override
            public long getDelay(TimeUnit arg0) {
                return 0L;
            }

            @Override
            public int compareTo(Delayed arg0) {
                return 0;
            }

            @Override
            public boolean cancel(boolean arg0) {
                return false;
            }

            @Override
            public Void get() throws InterruptedException, ExecutionException {
                command.run();
                return null;
            }

            @Override
            public Void get(long arg0, TimeUnit arg1) throws InterruptedException, ExecutionException, TimeoutException {
                command.run();
                return null;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return false;
            }
        };
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        throw new IllegalStateException();
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        throw new IllegalStateException();
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        throw new IllegalStateException();
    }

    public static class TaskInfo {
        public final Runnable task;
        public final Duration delay;

        TaskInfo(Runnable task, Duration delay) {
            this.task = task;
            this.delay = delay;
        }
    }
}

