package com.atlassian.upm.license.role.confluence;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;

import com.atlassian.upm.license.role.spi.AbstractLicensingRole;
import com.atlassian.user.Group;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Confluence implementation of licensing roles. Currently this is based on groups.
 */
public class ConfluenceLicensingRole extends AbstractLicensingRole
{
    private static final String MANAGEMENT_PAGE_URL = "/admin/users/domembersofgroupsearch.action";

    private final ConfluenceRoleBasedLicenseManager manager;
    private final Group group;

    public ConfluenceLicensingRole(ConfluenceRoleBasedLicenseManager manager, Group group, String key)
    {
        super(key, null, null);
        this.manager = checkNotNull(manager, "manager");
        this.group = checkNotNull(group, "group");
    }

    @Override
    public URI getManagementPage()
    {
        try
        {
            // Confluence does not provide a URL builder to construct this. As a result we have to construct it manually.
            return URI.create(MANAGEMENT_PAGE_URL + "?membersOfGroupTerm=" + URLEncoder.encode(getKey(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e)
        {
            return URI.create(MANAGEMENT_PAGE_URL);
        }
    }

    @Override
    public boolean isUserInRole(String userKey)
    {
        return manager.hasMembership(group, userKey);
    }

    @Override
    public int getRoleCount()
    {
        return manager.getMembershipCount(group.getName());
    }
}
