/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license.storage.lib;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.license.storage.lib.ManagerAccessor;
import com.atlassian.upm.license.storage.lib.PluginLicenseStoragePluginPermissionDeniedException;
import com.atlassian.upm.license.storage.lib.PluginLicenseStoragePluginUnresolvedException;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.atlassian.upm.license.storage.lib.VersionChecker;
import com.atlassian.upm.license.storage.plugin.PluginLicenseStorageManager;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.concurrent.Callable;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ThirdPartyPluginLicenseStorageManagerImpl
implements ApplicationContextAware,
ThirdPartyPluginLicenseStorageManager {
    private ManagerAccessor managerAccessor;
    private final ApplicationProperties applicationProperties;
    private final PluginAccessor pluginAccessor;
    private final UserManager userManager;

    public ThirdPartyPluginLicenseStorageManagerImpl(ApplicationProperties applicationProperties, PluginAccessor pluginAccessor, UserManager userManager) {
        this(applicationProperties, pluginAccessor, userManager, null);
    }

    public ThirdPartyPluginLicenseStorageManagerImpl(ApplicationProperties applicationProperties, PluginAccessor pluginAccessor, UserManager userManager, ManagerAccessor managerAccessor) {
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties, (Object)"applicationProperties");
        this.pluginAccessor = (PluginAccessor)Preconditions.checkNotNull((Object)pluginAccessor, (Object)"pluginAccessor");
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager, (Object)"userManager");
        this.managerAccessor = managerAccessor;
    }

    @Override
    public Option<PluginLicense> getLicense() throws PluginLicenseStoragePluginUnresolvedException {
        Callable<Option<PluginLicense>> withUpm2 = new Callable<Option<PluginLicense>>(){

            @Override
            public Option<PluginLicense> call() throws Exception {
                return ThirdPartyPluginLicenseStorageManagerImpl.this.getLicenseManager().getLicense();
            }
        };
        Callable<Option<PluginLicense>> withoutUpm2 = new Callable<Option<PluginLicense>>(){

            @Override
            public Option<PluginLicense> call() throws Exception {
                return ThirdPartyPluginLicenseStorageManagerImpl.this.getStorageManager().getLicense();
            }
        };
        return this.execute(withUpm2, withoutUpm2, false);
    }

    @Override
    public Option<String> getRawLicense() throws PluginLicenseStoragePluginUnresolvedException {
        Callable<Option<String>> withUpm2 = new Callable<Option<String>>(){

            @Override
            public Option<String> call() throws Exception {
                return ThirdPartyPluginLicenseStorageManagerImpl.this.getLicenseManager().getLicense().map((Function)new Function<PluginLicense, String>(){

                    public String apply(PluginLicense license) {
                        return license.getRawLicense();
                    }
                });
            }
        };
        Callable<Option<String>> withoutUpm2 = new Callable<Option<String>>(){

            @Override
            public Option<String> call() throws Exception {
                return ThirdPartyPluginLicenseStorageManagerImpl.this.getStorageManager().getRawLicense();
            }
        };
        return this.execute(withUpm2, withoutUpm2, false);
    }

    @Override
    public Option<String> setRawLicense(final String rawLicense) throws PluginLicenseStoragePluginUnresolvedException {
        Callable<Option<String>> withUpm2 = new Callable<Option<String>>(){

            @Override
            public Option<String> call() throws Exception {
                throw new UnsupportedOperationException("Cannot set license manually when UPM is license-aware. Please use UPM's licensing UI.");
            }
        };
        Callable<Option<String>> withoutUpm2 = new Callable<Option<String>>(){

            @Override
            public Option<String> call() throws Exception {
                return ThirdPartyPluginLicenseStorageManagerImpl.this.getStorageManager().setRawLicense(rawLicense);
            }
        };
        return this.execute(withUpm2, withoutUpm2, true);
    }

    @Override
    public Option<String> removeRawLicense() throws PluginLicenseStoragePluginUnresolvedException {
        Callable<Option<String>> withUpm2 = new Callable<Option<String>>(){

            @Override
            public Option<String> call() throws Exception {
                throw new UnsupportedOperationException("Cannot remove license manually when UPM is license-aware. Please use UPM's licensing UI.");
            }
        };
        Callable<Option<String>> withoutUpm2 = new Callable<Option<String>>(){

            @Override
            public Option<String> call() throws Exception {
                return ThirdPartyPluginLicenseStorageManagerImpl.this.getStorageManager().removeRawLicense();
            }
        };
        return this.execute(withUpm2, withoutUpm2, true);
    }

    @Override
    public Option<PluginLicense> validateLicense(final String rawLicense) throws PluginLicenseStoragePluginUnresolvedException {
        Callable<Option<PluginLicense>> withUpm2 = new Callable<Option<PluginLicense>>(){

            @Override
            public Option<PluginLicense> call() throws Exception {
                throw new UnsupportedOperationException("Cannot validate license manually when UPM is license-aware. Please use UPM's licensing UI.");
            }
        };
        Callable<Option<PluginLicense>> withoutUpm2 = new Callable<Option<PluginLicense>>(){

            @Override
            public Option<PluginLicense> call() throws Exception {
                return ThirdPartyPluginLicenseStorageManagerImpl.this.getStorageManager().validateLicense(rawLicense);
            }
        };
        return this.execute(withUpm2, withoutUpm2, false);
    }

    @Override
    public boolean isUpmLicensingAware() {
        return VersionChecker.isUpm201OrLaterInstalled(this.pluginAccessor);
    }

    @Override
    public String getPluginKey() throws PluginLicenseStoragePluginUnresolvedException {
        Callable<String> withUpm2 = new Callable<String>(){

            @Override
            public String call() throws Exception {
                return ThirdPartyPluginLicenseStorageManagerImpl.this.getLicenseManager().getPluginKey();
            }
        };
        Callable<String> withoutUpm2 = new Callable<String>(){

            @Override
            public String call() throws Exception {
                return ThirdPartyPluginLicenseStorageManagerImpl.this.getStorageManager().getPluginKey();
            }
        };
        return this.execute(withUpm2, withoutUpm2, false);
    }

    @Override
    public URI getPluginManagementUri() throws PluginLicenseStoragePluginUnresolvedException {
        return URI.create(this.applicationProperties.getBaseUrl() + "/plugins/servlet/upm?fragment=manage/" + this.getPluginKey()).normalize();
    }

    @Override
    public boolean isOnDemand() {
        return Boolean.parseBoolean(System.getProperty("atlassian.upm.on.demand", "false"));
    }

    private <T> T execute(Callable<T> withUpm2, Callable<T> withoutUpm2, boolean enforceAdmin) throws PluginLicenseStoragePluginUnresolvedException {
        if (enforceAdmin && !this.hasAdminPermission()) {
            throw new PluginLicenseStoragePluginPermissionDeniedException(this.userManager.getRemoteUsername());
        }
        this.registerOsgiWires();
        try {
            if (this.isUpmLicensingAware()) {
                try {
                    return withUpm2.call();
                }
                catch (ClassCastException e) {
                    return withoutUpm2.call();
                }
            }
            return withoutUpm2.call();
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (PluginLicenseStoragePluginUnresolvedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PluginLicenseStoragePluginUnresolvedException(e);
        }
    }

    private PluginLicenseStorageManager getStorageManager() throws PluginLicenseStoragePluginUnresolvedException {
        return this.managerAccessor.getStorageManager();
    }

    private PluginLicenseManager getLicenseManager() {
        return this.managerAccessor.getLicenseManager();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.managerAccessor = new ManagerAccessor(applicationContext);
    }

    private boolean hasAdminPermission() {
        String user = this.userManager.getRemoteUsername();
        try {
            return user != null && (this.userManager.isAdmin(user) || this.userManager.isSystemAdmin(user));
        }
        catch (NoSuchMethodError e) {
            return user != null && this.userManager.isSystemAdmin(user);
        }
    }

    private void registerOsgiWires() {
        Class<Option> clazz1 = Option.class;
        Class<PluginLicense> clazz2 = PluginLicense.class;
        Class<PluginLicenseManager> clazz3 = PluginLicenseManager.class;
    }
}

