/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license.storage.lib;

import com.atlassian.plugin.JarPluginArtifact;
import com.atlassian.plugin.PluginArtifact;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public abstract class PluginArtifactFactory {
    private static final int DOWNLOAD_BUFFER_SIZE = 4096;

    public static PluginArtifact fromURI(URI uri) throws IOException {
        return PluginArtifactFactory.fromInputStream(uri.toURL().openStream(), uri.getPath());
    }

    public static PluginArtifact fromFile(String resourcePath) throws IOException {
        InputStream in = PluginArtifactFactory.class.getClassLoader().getResourceAsStream(resourcePath);
        return PluginArtifactFactory.fromInputStream(in, resourcePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PluginArtifact fromInputStream(InputStream in, String resourcePath) throws IOException {
        File file = File.createTempFile("plugin.", "." + PluginArtifactFactory.extractFileName(resourcePath));
        FileOutputStream out = null;
        try {
            if (in == null) {
                PluginArtifact pluginArtifact = null;
                return pluginArtifact;
            }
            out = FileUtils.openOutputStream((File)file);
            PluginArtifactFactory.copy(in, out);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)out);
        }
        return new JarPluginArtifact(file);
    }

    private static String extractFileName(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    private static void copy(InputStream in, FileOutputStream out) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        while (-1 != (n = in.read(buffer))) {
            out.write(buffer, 0, n);
        }
    }
}

