/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license.storage.lib;

import com.atlassian.upm.api.license.HostLicenseInformation;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.license.storage.lib.LazyReference;
import com.atlassian.upm.license.storage.lib.PluginLicenseManagerAccessor;
import com.atlassian.upm.license.storage.lib.PluginLicenseStoragePluginUnresolvedException;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManagerAccessor;
import com.atlassian.upm.license.storage.lib.UpmLicenseInformationAccessor;
import com.atlassian.upm.license.storage.plugin.PluginLicenseStorageManager;
import org.springframework.context.ApplicationContext;

class ManagerAccessor {
    private final LazyReference<ThirdPartyPluginLicenseStorageManagerAccessor> thirdPartyAccessor;
    private final LazyReference<PluginLicenseManagerAccessor> licenseManagerAccessor;
    private final LazyReference<UpmLicenseInformationAccessor> upmLicenseInformationAccessor;

    ManagerAccessor(final ApplicationContext applicationContext) {
        this.thirdPartyAccessor = new LazyReference<ThirdPartyPluginLicenseStorageManagerAccessor>(){

            @Override
            protected ThirdPartyPluginLicenseStorageManagerAccessor create() throws Exception {
                try {
                    Class<?> accessorImplClass = this.getClass().getClassLoader().loadClass("com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManagerAccessorImpl");
                    return (ThirdPartyPluginLicenseStorageManagerAccessor)applicationContext.getAutowireCapableBeanFactory().createBean(accessorImplClass, 3, false);
                }
                catch (Exception e) {
                    throw new PluginLicenseStoragePluginUnresolvedException(e);
                }
            }
        };
        this.licenseManagerAccessor = new LazyReference<PluginLicenseManagerAccessor>(){

            @Override
            protected PluginLicenseManagerAccessor create() throws Exception {
                try {
                    Class<?> accessorImplClass = this.getClass().getClassLoader().loadClass("com.atlassian.upm.license.storage.lib.PluginLicenseManagerAccessorImpl");
                    return (PluginLicenseManagerAccessor)applicationContext.getAutowireCapableBeanFactory().createBean(accessorImplClass, 3, false);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to find plugin license manager", e);
                }
            }
        };
        this.upmLicenseInformationAccessor = new LazyReference<UpmLicenseInformationAccessor>(){

            @Override
            protected UpmLicenseInformationAccessor create() throws Exception {
                try {
                    Class<?> accessorImplClass = this.getClass().getClassLoader().loadClass("com.atlassian.upm.license.storage.lib.UpmLicenseInformationAccessorImpl");
                    return (UpmLicenseInformationAccessor)applicationContext.getAutowireCapableBeanFactory().createBean(accessorImplClass, 3, false);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to find UPM License Information", e);
                }
            }
        };
    }

    PluginLicenseStorageManager getStorageManager() throws PluginLicenseStoragePluginUnresolvedException {
        return this.thirdPartyAccessor.get().getPluginLicenseStorageManager();
    }

    PluginLicenseManager getLicenseManager() {
        return this.licenseManagerAccessor.get().getPluginLicenseManager();
    }

    HostLicenseInformation getUpmHostLicenseInformation() {
        return this.upmLicenseInformationAccessor.get().getHostLicenseInformation();
    }
}

