package com.atlassian.upm.license.storage.lib;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

/**
 * Utility for properly encoding URLs.
 */
abstract class UrlEncoder
{
    static String encode(String s)
    {
        try
        {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e)
        {
            throw new RuntimeException("UTF-8 is an unsupported encoding", e);
        }
    }
}
