package com.atlassian.upm.license.storage.lib;

import com.atlassian.upm.api.license.HostLicenseInformation;

import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.osgi.context.BundleContextAware;

public class UpmLicenseInformationAccessorImpl implements BundleContextAware, DisposableBean, InitializingBean, UpmLicenseInformationAccessor
{
    private BundleContext bundleContext;
    private ServiceTracker serviceTracker;

    public void setBundleContext(BundleContext bundleContext)
    {
        this.bundleContext = bundleContext;
    }

    public void afterPropertiesSet() throws Exception
    {
        serviceTracker = new ServiceTracker(bundleContext, HostLicenseInformation.class.getName(), null);
        serviceTracker.open();
    }

    public void destroy() throws Exception
    {
        serviceTracker.close();
    }

    @Override
    public HostLicenseInformation getHostLicenseInformation()
    {
        HostLicenseInformation service = (HostLicenseInformation) serviceTracker.getService();
        if (service == null)
        {
            throw new IllegalStateException("Unable to find HostLicenseInformation component. Is UPM 2.8+ installed?");
        }
        return service;
    }
}
