package com.atlassian.upm.license.storage.lib;

import com.atlassian.upm.license.storage.plugin.PluginLicenseStorageManager;

import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.osgi.context.BundleContextAware;

public class ThirdPartyPluginLicenseStorageManagerAccessorImpl implements BundleContextAware, DisposableBean, InitializingBean, ThirdPartyPluginLicenseStorageManagerAccessor
{
    private BundleContext bundleContext;
    private ServiceTracker serviceTracker;

    public void setBundleContext(BundleContext bundleContext)
    {
        this.bundleContext = bundleContext;
    }

    public void afterPropertiesSet() throws Exception
    {
        serviceTracker = new ServiceTracker(bundleContext, PluginLicenseStorageManager.class.getName(), null);
        serviceTracker.open();
    }

    public void destroy() throws Exception
    {
        serviceTracker.close();
    }

    @Override
    public PluginLicenseStorageManager getPluginLicenseStorageManager() throws PluginLicenseStoragePluginUnresolvedException
    {
        PluginLicenseStorageManager service = (PluginLicenseStorageManager) serviceTracker.getService();
        if (service == null)
        {
            throw new PluginLicenseStoragePluginUnresolvedException();
        }
        return service;
    }
}
