package com.atlassian.marketplace.client.util;

import java.net.URI;

import com.atlassian.marketplace.client.model.Links;

import com.google.common.collect.ImmutableList;

public abstract class ModelUtil
{
    public static URI requireLink(Links links, String rel)
    {
        for (URI ret: links.get(rel))
        {
            return ret;
        }
        throw new IllegalArgumentException("missing required REST link: " + rel);
    }
    
    public static <T> ImmutableList<T> requireList(Iterable<T> list, String name)
    {
        return ImmutableList.copyOf(requireProperty(list, name));
    }
    
    public static <T> T requireProperty(T value, String name)
    {
        if (value == null)
        {
            throw new IllegalArgumentException("missing required JSON property: " + name);
        }
        return value;
    }
}
