/**
 * Entities in the Atlassian Marketplace API.
 * <p>
 * Characteristics of these classes:
 * <ul>
 * <li> They are all immutable.
 * <li> No property getter method will ever return <tt>null</tt>.  Optional properties use the
 * {@link com.atlassian.upm.api.util.Option} type to represent either a value or "none".
 * <li> All {@link java.util.Date} values are UTC.
 * <li> Many entities have a <tt>getLinks()</tt> method that returns an object containing REST
 * API links. Links with special meanings can be accessed through convenience methods such as
 * {@link Image#getImageUri()}; avoid using the links map directly.
 * <li> Constructors are package-private and are not meant to be used directly.  Use
 * {@link ModelBuilders} if you need to construct instances of these classes.
 */
package com.atlassian.marketplace.client.model;