package com.atlassian.marketplace.client.model;

import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

import static com.atlassian.marketplace.client.util.ModelUtil.requireProperty;

/**
 * A range of application versions compatible with a plugin version.
 */
public final class VersionCompatibility
{
    @JsonProperty private final String applicationName;
    @JsonProperty private final VersionAndBuildNumber min;
    @JsonProperty private final VersionAndBuildNumber max;
    
    @JsonCreator
    public VersionCompatibility(@JsonProperty("applicationName") String applicationName,
                                @JsonProperty("min") VersionAndBuildNumber min,
                                @JsonProperty("max") VersionAndBuildNumber max)
    {
        this.applicationName = requireProperty(applicationName, "applicationName");
        this.min = requireProperty(min, "min");
        this.max = requireProperty(max, "max");
    }

    /**
     * The application name (e.g. "Confluence").
     */
    public String getApplicationName()
    {
        return applicationName;
    }

    /**
     * The minimum application version and build number.
     */
    public VersionAndBuildNumber getMin()
    {
        return min;
    }

    /**
     * The maximum application version and build number.
     */
    public VersionAndBuildNumber getMax()
    {
        return max;
    }    

    public static final class VersionAndBuildNumber
    {
        @JsonProperty private final String version;
        @JsonProperty private final long buildNumber;
        
        @JsonCreator
        public VersionAndBuildNumber(@JsonProperty("version") String version,
                                     @JsonProperty("buildNumber") Long buildNumber)
        {
            this.version = requireProperty(version, "version");
            this.buildNumber = requireProperty(buildNumber, "buildNumber");
        }
        
        public String getVersion()
        {
            return version;
        }
        
        public long getBuildNumber()
        {
            return buildNumber;
        }
    }
}
