package com.atlassian.marketplace.client.model;

import com.atlassian.upm.api.util.Option;

import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

import static com.atlassian.marketplace.client.util.ModelUtil.requireProperty;
import static com.atlassian.upm.api.util.Option.option;

/**
 * Abbreviated information about a user account on the Atlassian Marketplace site.
 */
public class UserSummary
{
    @JsonProperty private final Links links;
    @JsonProperty private final long id;
    @JsonProperty private final String name;
    @JsonProperty private final String email;
    
    @JsonCreator
    UserSummary(@JsonProperty("links") Links links,
                @JsonProperty("id") Long id,
                @JsonProperty("name") String name,
                @JsonProperty("email") String email)
    {
        this.links = requireProperty(links, "links");
        this.id = requireProperty(id, "id");
        this.name = requireProperty(name, "name");
        this.email = email;
    }

    public Links getLinks()
    {
        return links;
    }

    /**
     * A unique identifier for the user.
     */
    public long getId()
    {
        return id;
    }

    /**
     * The human-readable name.
     */
    public String getName()
    {
        return name;
    }

    /**
     * The email address.
     */
    public Option<String> getEmail()
    {
        return option(email);
    }    
}
