package com.atlassian.marketplace.client.model;

import java.util.Collection;

import com.atlassian.upm.api.util.Option;

import com.google.common.collect.ImmutableList;

import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

import static com.atlassian.marketplace.client.util.ModelUtil.requireList;
import static com.atlassian.marketplace.client.util.ModelUtil.requireProperty;
import static com.atlassian.upm.api.util.Option.option;

/**
 * Information about images associated with a plugin.
 */
public final class PluginMedia
{
    @JsonProperty private final Icons icons;
    @JsonProperty private final Banner banner;
    @JsonProperty private final String youtubeId;
    @JsonProperty private final Collection<Screenshot> screenshots;
    
    @JsonCreator
    PluginMedia(@JsonProperty("icons") Icons icons,
                @JsonProperty("banner") Banner banner,
                @JsonProperty("youtubeId") String youtubeId,
                @JsonProperty("screenshots") Collection<Screenshot> screenshots)
    {
        this.icons = requireProperty(icons, "icons");
        this.banner = banner;  // optional
        this.youtubeId = youtubeId;  // optional
        this.screenshots = requireList(screenshots, "screenshots");
    }

    /**
     * The plugin icons.
     */
    public Icons getIcons()
    {
        return icons;
    }

    /**
     * The plugin banner image, if any.
     */
    @JsonIgnore
    public Option<Banner> getBanner()
    {
        return option(banner);
    }

    /**
     * A YouTube ID for a video associated with the plugin, if any.
     */
    @JsonIgnore
    public Option<String> getYoutubeId()
    {
        return option(youtubeId);
    }

    /**
     * Screenshot images for the plugin, if any.
     */
    @JsonIgnore
    public Iterable<Screenshot> getScreenshots()
    {
        return ImmutableList.copyOf(screenshots);
    }
}
