package com.atlassian.marketplace.client.model;

import java.util.Date;

import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

import static com.atlassian.marketplace.client.util.ModelUtil.requireProperty;

/**
 * Information about the last time an entity was modified.
 */
public final class Modification
{
    @JsonProperty private final String by;
    @JsonProperty private final Date date;
    
    @JsonCreator
    Modification(@JsonProperty("by") String by,
                 @JsonProperty("date") Date date)
    {
        this.by = requireProperty(by, "by");
        this.date = requireProperty(date, "date");
    }

    /**
     * The username of the user who made the last change.
     */
    public String getBy()
    {
        return by;
    }

    /**
     * The date of the last change.
     */
    public Date getDate()
    {
        return date;
    }    
}
