package com.atlassian.marketplace.client.model;

import com.atlassian.upm.api.util.Option;

import static com.atlassian.upm.api.util.Option.none;

import static com.atlassian.upm.api.util.Option.some;

/**
 * Indicates which payment system, if any, is used for buying licenses for a plugin.
 */
public enum MarketplaceType
{
    /**
     * The plugin does not require purchase.
     */
    FREE("Free"),
    /**
     * The plugin can be purchased through the vendor.
     */
    PAID_VIA_VENDOR("Paid via Vendor"),
    /**
     * The plugin can be purchased through the Atlassian Marketplace.
     */
    PAID_VIA_ATLASSIAN("Paid via Atlassian");
    
    private final String displayName;
    
    private MarketplaceType(String displayName)
    {
        this.displayName = displayName;
    }
    
    public String getDisplayName()
    {
        return displayName;
    }
    
    public static Option<MarketplaceType> fromName(String name)
    {
        for (MarketplaceType t: MarketplaceType.values())
        {
            if (t.getDisplayName().equalsIgnoreCase(name))
            {
                return some(t);
            }
        }
        return none();
    }
}
